#include "sys.h"
#include "mmc_sd.h"			   
#include "spi.h"
#include "usart.h"
#include "ff.h"
//////////////////////////////////////////////////////////////////////////////////	 
//ֻѧϰʹãδɣκ;
//ALIENTEKսSTM32
//SD 	   
//ԭ@ALIENTEK
//̳:www.openedv.com
//޸:2012/9/17
//汾V1.0
//ȨУؾ
//Copyright(C) ӿƼ޹˾ 2009-2019
//All rights reserved									  
//////////////////////////////////////////////////////////////////////////////////
					   
u8  SD_Type=0;//SD 
////////////////////////////////////ֲ޸/////////////////////////////////// 
//ֲʱĽӿ
//data:Ҫд
//ֵ:
u8 SD_SPI_ReadWriteByte(u8 data)
{
	return SPIx_ReadWriteByte(data);
}
//SDʼʱ,Ҫ
void SD_SPI_SpeedLow(void)
{
 	SPIx_SetSpeed(SPI_SPEED_256);//õģʽ	
}
//SDʱ,Ը
void SD_SPI_SpeedHigh(void)
{
 	SPIx_SetSpeed(SPI_SPEED_4);//õģʽ	
}
//SPIӲʼ
void SD_SPI_Init(void)
{
     //ӲSDĿ
	//NRF24L01/W25X16ȵӰ
	RCC->APB2ENR|=1<<2;       //PORTAʱʹ 
	GPIOA->CRL&=0XFFF000FF; 
	GPIOA->CRL|=0X00033300;//PA2.3.4  	    
	GPIOA->ODR|=0X7<<2;    //PA2.3.4 
	SPIx_Init();
 	SD_SPI_SpeedLow();//õģʽ	 
	SD_CS=1;
}
///////////////////////////////////////////////////////////////////////////////////
//ȡѡ,ͷSPI
void SD_DisSelect(void)
{
	SD_CS=1;
 	SD_SPI_ReadWriteByte(0xff);//ṩ8ʱ
}
//ѡsd,ҵȴ׼OK
//ֵ:0,ɹ;1,ʧ;
u8 SD_Select(void)
{
	SD_CS=0;
	if(SD_WaitReady()==0)return 0;//ȴɹ
	SD_DisSelect();
	return 1;//ȴʧ
}
//ȴ׼
//ֵ:0,׼;,
u8 SD_WaitReady(void)
{
	u32 t=0;
	do
	{
		if(SD_SPI_ReadWriteByte(0XFF)==0XFF)return 0;//OK
		t++;		  	
	}while(t<0XFFFFFF);//ȴ 
	return 1;
}
//ȴSDӦ
//Response:ҪõĻӦֵ
//ֵ:0,ɹõ˸ûӦֵ
//    ,õӦֵʧ
u8 SD_GetResponse(u8 Response)
{
	u16 Count=0xFFFF;//ȴ	   						  
	while ((SD_SPI_ReadWriteByte(0XFF)!=Response)&&Count)Count--;//ȴõ׼ȷĻӦ  	  
	if (Count==0)return MSD_RESPONSE_FAILURE;//õӦʧ   
	else return MSD_RESPONSE_NO_ERROR;//ȷӦ
}
//sdȡһݰ
//buf:ݻ
//len:Ҫȡݳ.
//ֵ:0,ɹ;,ʧ;	
u8 SD_RecvData(u8*buf,u16 len)
{			  	  
	if(SD_GetResponse(0xFE))return 1;//ȴSDʼ0xFE
    while(len--)//ʼ
    {
        *buf=SD_SPI_ReadWriteByte(0xFF);
        buf++;
    }
    //2αCRCdummy CRC
    SD_SPI_ReadWriteByte(0xFF);
    SD_SPI_ReadWriteByte(0xFF);									  					    
    return 0;//ȡɹ
}
//sdдһݰ 512ֽ
//buf:ݻ
//cmd:ָ
//ֵ:0,ɹ;,ʧ;	
u8 SD_SendBlock(u8*buf,u8 cmd)
{	
	u16 t;		  	  
	if(SD_WaitReady())return 1;//ȴ׼ʧЧ
	SD_SPI_ReadWriteByte(cmd);
	if(cmd!=0XFD)//ǽָ
	{
		for(t=0;t<512;t++)SD_SPI_ReadWriteByte(buf[t]); 
	    SD_SPI_ReadWriteByte(0xFF);//crc
	    SD_SPI_ReadWriteByte(0xFF);
		t=SD_SPI_ReadWriteByte(0xFF);//Ӧ
		if((t&0x1F)!=0x05)return 2;//Ӧ									  					    
	}						 									  					    
    return 0;//дɹ
}

//SDһ
//: u8 cmd    
//      u32 arg  
//      u8 crc   crcУֵ	   
//ֵ:SDصӦ															  
u8 SD_SendCmd(u8 cmd, u32 arg, u8 crc)
{
    u8 r1;	
	u8 Retry=0; 
	SD_DisSelect();//ȡϴƬѡ
	if(SD_Select())return 0XFF;//ƬѡʧЧ 
	//
    SD_SPI_ReadWriteByte(cmd | 0x40);//ֱд
    SD_SPI_ReadWriteByte(arg >> 24);
    SD_SPI_ReadWriteByte(arg >> 16);
    SD_SPI_ReadWriteByte(arg >> 8);
    SD_SPI_ReadWriteByte(arg);	  
    SD_SPI_ReadWriteByte(crc); 
	if(cmd==CMD12)SD_SPI_ReadWriteByte(0xff);//Skip a stuff byte when stop reading
    //ȴӦʱ˳
	Retry=0X1F;
	do
	{
		r1=SD_SPI_ReadWriteByte(0xFF);
	}while((r1&0X80) && Retry--);	 
	//״ֵ̬
    return r1;
}		    																			  
//ȡSDCIDϢϢ
//: u8 *cid_data(CIDڴ棬16Byte	  
//ֵ:0NO_ERR
//		 1														   
u8 SD_GetCID(u8 *cid_data)
{
    u8 r1;	   
    //CMD10CID
    r1=SD_SendCmd(CMD10,0,0x01);
    if(r1==0x00)
	{
		r1=SD_RecvData(cid_data,16);//16ֽڵ	 
    }
	SD_DisSelect();//ȡƬѡ
	if(r1)return 1;
	else return 0;
}																				  
//ȡSDCSDϢٶϢ
//:u8 *cid_data(CIDڴ棬16Byte	    
//ֵ:0NO_ERR
//		 1														   
u8 SD_GetCSD(u8 *csd_data)
{
    u8 r1;	 
    r1=SD_SendCmd(CMD9,0,0x01);//CMD9CSD
    if(r1==0)
	{
    	r1=SD_RecvData(csd_data, 16);//16ֽڵ 
    }
	SD_DisSelect();//ȡƬѡ
	if(r1)return 1;
	else return 0;
}  
//ȡSD   
//ֵ:0 ȡ 
//       :SD(/512ֽ)
//ÿֽΪ512Ϊ512ʼͨ.														  
u32 SD_GetSectorCount(void)
{
    u8 csd[16];
    u32 Capacity;  
    u8 n;
	u16 csize;  					    
	//ȡCSDϢڼ0
    if(SD_GetCSD(csd)!=0) return 0;	    
    //ΪSDHC淽ʽ
    if((csd[0]&0xC0)==0x40)	 //V2.00Ŀ
    {	
		csize = csd[9] + ((u16)csd[8] << 8) + 1;
		Capacity = (u32)csize << 10;//õ	 		   
    }else//V1.XXĿ
    {	
		n = (csd[5] & 15) + ((csd[10] & 128) >> 7) + ((csd[9] & 3) << 1) + 2;
		csize = (csd[8] >> 6) + ((u16)csd[7] << 2) + ((u16)(csd[6] & 3) << 10) + 1;
		Capacity= (u32)csize << (n - 9);//õ   
    }
    return Capacity;
}
//ʼSD
u8 SD_Initialize(void)
{
    u8 r1;      // SDķֵ
    u16 retry;  // гʱ
    u8 buf[4];  
	u16 i;

	SD_SPI_Init();		//ʼIO
 	SD_SPI_SpeedLow();	//õģʽ 
 	for(i=0;i<10;i++)SD_SPI_ReadWriteByte(0XFF);//74
	retry=20;
	do
	{
		r1=SD_SendCmd(CMD0,0,0x95);//IDLE״̬
	}while((r1!=0X01) && retry--);
 	SD_Type=0;//Ĭ޿
	if(r1==0X01)
	{
		if(SD_SendCmd(CMD8,0x1AA,0x87)==1)//SD V2.0
		{
			for(i=0;i<4;i++)buf[i]=SD_SPI_ReadWriteByte(0XFF);	//Get trailing return value of R7 resp
			if(buf[2]==0X01&&buf[3]==0XAA)//Ƿ֧2.7~3.6V
			{
				retry=0XFFFE;
				do
				{
					SD_SendCmd(CMD55,0,0X01);	//CMD55
					r1=SD_SendCmd(CMD41,0x40000000,0X01);//CMD41
				}while(r1&&retry--);
				if(retry&&SD_SendCmd(CMD58,0,0X01)==0)//SD2.0汾ʼ
				{
					for(i=0;i<4;i++)buf[i]=SD_SPI_ReadWriteByte(0XFF);//õOCRֵ
					if(buf[0]&0x40)SD_Type=SD_TYPE_V2HC;    //CCS
					else SD_Type=SD_TYPE_V2;   
				}
			}
		}else//SD V1.x/ MMC	V3
		{
			SD_SendCmd(CMD55,0,0X01);		//CMD55
			r1=SD_SendCmd(CMD41,0,0X01);	//CMD41
			if(r1<=1)
			{		
				SD_Type=SD_TYPE_V1;
				retry=0XFFFE;
				do //ȴ˳IDLEģʽ
				{
					SD_SendCmd(CMD55,0,0X01);	//CMD55
					r1=SD_SendCmd(CMD41,0,0X01);//CMD41
				}while(r1&&retry--);
			}else//MMC֧CMD55+CMD41ʶ
			{
				SD_Type=SD_TYPE_MMC;//MMC V3
				retry=0XFFFE;
				do //ȴ˳IDLEģʽ
				{											    
					r1=SD_SendCmd(CMD1,0,0X01);//CMD1
				}while(r1&&retry--);  
			}
			if(retry==0||SD_SendCmd(CMD16,512,0X01)!=0)SD_Type=SD_TYPE_ERR;//Ŀ
		}
	}
	SD_DisSelect();//ȡƬѡ
	SD_SPI_SpeedHigh();//
	if(SD_Type)return 0;
	else if(r1)return r1; 	   
	return 0xaa;//
}
//SD
//buf:ݻ
//sector:
//cnt:
//ֵ:0,ok;,ʧ.
u8 SD_ReadDisk(u8*buf,u32 sector,u8 cnt)
{
	u8 r1;
	if(SD_Type!=SD_TYPE_V2HC)sector <<= 9;//תΪֽڵַ
	if(cnt==1)
	{
		r1=SD_SendCmd(CMD17,sector,0X01);//
		if(r1==0)//ָͳɹ
		{
			r1=SD_RecvData(buf,512);//512ֽ	   
		}
	}else
	{
		r1=SD_SendCmd(CMD18,sector,0X01);//
		do
		{
			r1=SD_RecvData(buf,512);//512ֽ	 
			buf+=512;  
		}while(--cnt && r1==0); 	
		SD_SendCmd(CMD12,0,0X01);	//ֹͣ
	}   
	SD_DisSelect();//ȡƬѡ
	return r1;//
}
//дSD
//buf:ݻ
//sector:ʼ
//cnt:
//ֵ:0,ok;,ʧ.
u8 SD_WriteDisk(u8*buf,u32 sector,u8 cnt)
{
	u8 r1;
	if(SD_Type!=SD_TYPE_V2HC)sector *= 512;//תΪֽڵַ
	if(cnt==1)
	{
		r1=SD_SendCmd(CMD24,sector,0X01);//
		if(r1==0)//ָͳɹ
		{
			r1=SD_SendBlock(buf,0xFE);//д512ֽ	   
		}
	}else
	{
		if(SD_Type!=SD_TYPE_MMC)
		{
			SD_SendCmd(CMD55,0,0X01);	
			SD_SendCmd(CMD23,cnt,0X01);//ָ	
		}
 		r1=SD_SendCmd(CMD25,sector,0X01);//
		if(r1==0)
		{
			do
			{
				r1=SD_SendBlock(buf,0xFC);//512ֽ	 
				buf+=512;  
			}while(--cnt && r1==0);
			r1=SD_SendBlock(0,0xFD);//512ֽ 
		}
	}   
	SD_DisSelect();//ȡƬѡ
	return r1;//
}	   
























	  






