#include "24l01.h"
#include "lcd.h"
#include "delay.h"
#include "spi.h"
//////////////////////////////////////////////////////////////////////////////////	 
//ֻѧϰʹãδɣκ;
//Mini STM32
//NRF24L01 	   
//ԭ@ALIENTEK
//̳:www.openedv.com
//޸:2010/6/16 
//汾V1.0
//ȨУؾ
//Copyright(C) ԭ 2009-2019
//All rights reserved
////////////////////////////////////////////////////////////////////////////////// 	  
 
	 

const u8 TX_ADDRESS[TX_ADR_WIDTH]={0x34,0x43,0x10,0x10,0x01}; //͵ַ
const u8 RX_ADDRESS[RX_ADR_WIDTH]={0x34,0x43,0x10,0x10,0x01}; //͵ַ
							    
//ʼ24L01IO
void NRF24L01_Init(void)
{
	RCC->APB2ENR|=1<<2;    //ʹPORTAʱ 
	RCC->APB2ENR|=1<<4;    //ʹPORTCʱ 
	GPIOA->CRL&=0XFFF000FF;//PA4
	GPIOA->CRL|=0X00033300; 
	GPIOA->ODR|=7<<2;	   //PA2.3.4 1		 
	GPIOC->CRL&=0XFF00FFFF;//PC4 PC5
	GPIOC->CRL|=0X00830000; 
	GPIOC->ODR|=3<<4;	   //	 
	SPIx_Init();    //ʼSPI
	NRF24L01_CE=0; 	//ʹ24L01
	NRF24L01_CSN=1;	//SPIƬѡȡ		  		 		  
}
//24L01Ƿ
//ֵ:0ɹ;1ʧ	
u8 NRF24L01_Check(void)
{
	u8 buf[5]={0XA5,0XA5,0XA5,0XA5,0XA5};
	u8 i;
	SPIx_SetSpeed(SPI_SPEED_8); //spiٶΪ9Mhz24L01SPIʱΪ10Mhz   	 
	NRF24L01_Write_Buf(WRITE_REG+TX_ADDR,buf,5);//д5ֽڵĵַ.	
	NRF24L01_Read_Buf(TX_ADDR,buf,5); //дĵַ  
	for(i=0;i<5;i++)if(buf[i]!=0XA5)break;	 							   
	if(i!=5)return 1;//24L01	
	return 0;		 //⵽24L01
}	 	 
//SPIдĴ
//reg:ָĴַ
//value:дֵ
u8 NRF24L01_Write_Reg(u8 reg,u8 value)
{
	u8 status;	
   	NRF24L01_CSN=0;                 //ʹSPI
  	status =SPIx_ReadWriteByte(reg);//ͼĴ 
  	SPIx_ReadWriteByte(value);      //дĴֵ
  	NRF24L01_CSN=1;                 //ֹSPI	   
  	return(status);       			//״ֵ̬
}
//ȡSPIĴֵ
//reg:ҪļĴ
u8 NRF24L01_Read_Reg(u8 reg)
{
	u8 reg_val;	    
 	NRF24L01_CSN = 0;          //ʹSPI		
  	SPIx_ReadWriteByte(reg);   //ͼĴ
  	reg_val=SPIx_ReadWriteByte(0XFF);//ȡĴ
  	NRF24L01_CSN = 1;          //ֹSPI		    
  	return(reg_val);           //״ֵ̬
}	
//ָλöָȵ
//reg:Ĵ(λ)
//*pBuf:ָ
//len:ݳ
//ֵ,˴ζ״̬Ĵֵ 
u8 NRF24L01_Read_Buf(u8 reg,u8 *pBuf,u8 len)
{
	u8 status,u8_ctr;	       
  	NRF24L01_CSN = 0;           //ʹSPI
  	status=SPIx_ReadWriteByte(reg);//ͼĴֵ(λ),ȡ״ֵ̬   	   
 	for(u8_ctr=0;u8_ctr<len;u8_ctr++)pBuf[u8_ctr]=SPIx_ReadWriteByte(0XFF);//
  	NRF24L01_CSN=1;       //رSPI
  	return status;        //ض״ֵ̬
}
//ָλдָȵ
//reg:Ĵ(λ)
//*pBuf:ָ
//len:ݳ
//ֵ,˴ζ״̬Ĵֵ
u8 NRF24L01_Write_Buf(u8 reg, u8 *pBuf, u8 len)
{
	u8 status,u8_ctr;	    
 	NRF24L01_CSN = 0;          //ʹSPI
  	status = SPIx_ReadWriteByte(reg);//ͼĴֵ(λ),ȡ״ֵ̬
  	for(u8_ctr=0; u8_ctr<len; u8_ctr++)SPIx_ReadWriteByte(*pBuf++); //д	 
  	NRF24L01_CSN = 1;       //رSPI
  	return status;          //ض״ֵ̬
}				   
//NRF24L01һ
//txbuf:׵ַ
//ֵ:״
u8 NRF24L01_TxPacket(u8 *txbuf)
{
	u8 sta;
 	SPIx_SetSpeed(SPI_SPEED_8);//spiٶΪ9Mhz24L01SPIʱΪ10Mhz   
	NRF24L01_CE=0;
  	NRF24L01_Write_Buf(WR_TX_PLOAD,txbuf,TX_PLOAD_WIDTH);//дݵTX BUF  32ֽ
 	NRF24L01_CE=1;//	   
	while(NRF24L01_IRQ!=0);//ȴ
	sta=NRF24L01_Read_Reg(STATUS);  //ȡ״̬Ĵֵ	   
	NRF24L01_Write_Reg(WRITE_REG+STATUS,sta); //TX_DSMAX_RTжϱ־
	if(sta&MAX_TX)//ﵽط
	{
		NRF24L01_Write_Reg(FLUSH_TX,0xff);//TX FIFOĴ 
		return MAX_TX; 
	}
	if(sta&TX_OK)//
	{
		return TX_OK;
	}
	return 0xff;//ԭʧ
}
//NRF24L01һ
//txbuf:׵ַ
//ֵ:0ɣ
u8 NRF24L01_RxPacket(u8 *rxbuf)
{
	u8 sta;		    							   
	SPIx_SetSpeed(SPI_SPEED_8); //spiٶΪ9Mhz24L01SPIʱΪ10Mhz   
	sta=NRF24L01_Read_Reg(STATUS);  //ȡ״̬Ĵֵ    	 
	NRF24L01_Write_Reg(WRITE_REG+STATUS,sta); //TX_DSMAX_RTжϱ־
	if(sta&RX_OK)//յ
	{
		NRF24L01_Read_Buf(RD_RX_PLOAD,rxbuf,RX_PLOAD_WIDTH);//ȡ
		NRF24L01_Write_Reg(FLUSH_RX,0xff);//RX FIFOĴ 
		return 0; 
	}	   
	return 1;//ûյκ
}					    
//úʼNRF24L01RXģʽ
//RXַ,дRXݿ,ѡRFƵ,ʺLNA HCURR
//CEߺ,RXģʽ,Խ		   
void RX_Mode(void)
{
	NRF24L01_CE=0;	  
  	NRF24L01_Write_Buf(WRITE_REG+RX_ADDR_P0,(u8*)RX_ADDRESS,RX_ADR_WIDTH);//дRXڵַ
	  
  	NRF24L01_Write_Reg(WRITE_REG+EN_AA,0x01);    //ʹͨ0ԶӦ    
  	NRF24L01_Write_Reg(WRITE_REG+EN_RXADDR,0x01);//ʹͨ0Ľյַ  	 
  	NRF24L01_Write_Reg(WRITE_REG+RF_CH,40);	     //RFͨƵ		  
  	NRF24L01_Write_Reg(WRITE_REG+RX_PW_P0,RX_PLOAD_WIDTH);//ѡͨ0Чݿ 	    
  	NRF24L01_Write_Reg(WRITE_REG+RF_SETUP,0x0f);//TX,0db,2Mbps,濪   
  	NRF24L01_Write_Reg(WRITE_REG+CONFIG, 0x0f);//ûģʽĲ;PWR_UP,EN_CRC,16BIT_CRC,ģʽ 
  	NRF24L01_CE = 1; //CEΪ,ģʽ 
}						 
//úʼNRF24L01TXģʽ
//TXַ,дTXݿ,RXԶӦĵַ,TX,ѡRFƵ,ʺLNA HCURR
//PWR_UP,CRCʹ
//CEߺ,RXģʽ,Խ		   
//CEΪߴ10us,.	 
void TX_Mode(void)
{														 
	NRF24L01_CE=0;	    
  	NRF24L01_Write_Buf(WRITE_REG+TX_ADDR,(u8*)TX_ADDRESS,TX_ADR_WIDTH);//дTXڵַ 
  	NRF24L01_Write_Buf(WRITE_REG+RX_ADDR_P0,(u8*)RX_ADDRESS,RX_ADR_WIDTH); //TXڵַ,ҪΪʹACK	  

  	NRF24L01_Write_Reg(WRITE_REG+EN_AA,0x01);     //ʹͨ0ԶӦ    
  	NRF24L01_Write_Reg(WRITE_REG+EN_RXADDR,0x01); //ʹͨ0Ľյַ  
  	NRF24L01_Write_Reg(WRITE_REG+SETUP_RETR,0x1a);//Զطʱ:500us + 86us;Զط:10
  	NRF24L01_Write_Reg(WRITE_REG+RF_CH,40);       //RFͨΪ40
  	NRF24L01_Write_Reg(WRITE_REG+RF_SETUP,0x0f);  //TX,0db,2Mbps,濪   
  	NRF24L01_Write_Reg(WRITE_REG+CONFIG,0x0e);    //ûģʽĲ;PWR_UP,EN_CRC,16BIT_CRC,ģʽ,ж
	NRF24L01_CE=1;//CEΪ,10us
}		  




