#include "gps.h" 
#include "led.h" 
#include "delay.h" 		   		   
#include "stdio.h"	 
#include "stdarg.h"	 
#include "string.h"	 
#include "math.h"
#include "usart.h"
//////////////////////////////////////////////////////////////////////////////////	 
//ֻѧϰʹãδɣκ;
//ALIENTEK STM32
//ATK-NEO-6M GPSģ	   
//ԭ@ALIENTEK
//̳:www.openedv.com
//޸:2013/2/24
//汾V1.0
//ȨУؾ
//Copyright(C) ӿƼ޹˾ 2009-2019
//All rights reserved									  
////////////////////////////////////////////////////////////////////////////////// 	   

//bufõcxڵλ
//ֵ:0~0XFE,λõƫ.
//       0XFF,ڵcx							  
u8 NMEA_Comma_Pos(u8 *buf,u8 cx)
{	 		    
	u8 *p=buf;
	while(cx)
	{		 
		if(*buf=='*'||*buf<' '||*buf>'z')return 0XFF;//'*'߷Ƿַ,򲻴ڵcx
		if(*buf==',')cx--;
		buf++;
	}
	return buf-p;	 
}
//m^n
//ֵ:m^nη.
u32 NMEA_Pow(u8 m,u8 n)
{
	u32 result=1;	 
	while(n--)result*=m;    
	return result;
}
//strתΪ,',''*'
//buf:ִ洢
//dx:Сλ,ظú
//ֵ:תֵ
int NMEA_Str2num(u8 *buf,u8*dx)
{
	u8 *p=buf;
	u32 ires=0,fres=0;
	u8 ilen=0,flen=0,i;
	u8 mask=0;
	int res;
	while(1) //õСĳ
	{
		if(*p=='-'){mask|=0X02;p++;}//Ǹ
		if(*p==','||(*p=='*'))break;//
		if(*p=='.'){mask|=0X01;p++;}//С
		else if(*p>'9'||(*p<'0'))	//зǷַ
		{	
			ilen=0;
			flen=0;
			break;
		}	
		if(mask&0X01)flen++;
		else ilen++;
		p++;
	}
	if(mask&0X02)buf++;	//ȥ
	for(i=0;i<ilen;i++)	//õ
	{  
		ires+=NMEA_Pow(10,ilen-1-i)*(buf[i]-'0');
	}
	if(flen>5)flen=5;	//ȡ5λС
	*dx=flen;	 		//Сλ
	for(i=0;i<flen;i++)	//õС
	{  
		fres+=NMEA_Pow(10,flen-1-i)*(buf[ilen+1+i]-'0');
	} 
	res=ires*NMEA_Pow(10,flen)+fres;
	if(mask&0X02)res=-res;		   
	return res;
}	  							 
//GPGSVϢ  ɼϢ
//gpsx:nmeaϢṹ
//buf:յGPSݻ׵ַ
void NMEA_GPGSV_Analysis(nmea_msg *gpsx,u8 *buf)
{
	u8 *p,*p1,dx;
	u8 len,i,j,slx=0;
	u8 posx;   	 
	p=buf;
	p1=(u8*)strstr((const char *)p,"$GPGSV");
	len=p1[7]-'0';								//õGPGSV
	posx=NMEA_Comma_Pos(p1,3); 					//õɼ
	if(posx!=0XFF)gpsx->svnum=NMEA_Str2num(p1+posx,&dx);
	for(i=0;i<len;i++)
	{	 
		p1=(u8*)strstr((const char *)p,"$GPGSV");  
		for(j=0;j<4;j++)
		{	  
			posx=NMEA_Comma_Pos(p1,4+j*4);
			if(posx!=0XFF)gpsx->slmsg[slx].num=NMEA_Str2num(p1+posx,&dx);	//õǱ
			else break; 
			posx=NMEA_Comma_Pos(p1,5+j*4);
			if(posx!=0XFF)gpsx->slmsg[slx].eledeg=NMEA_Str2num(p1+posx,&dx);//õ 
			else break;
			posx=NMEA_Comma_Pos(p1,6+j*4);
			if(posx!=0XFF)gpsx->slmsg[slx].azideg=NMEA_Str2num(p1+posx,&dx);//õǷλ
			else break; 
			posx=NMEA_Comma_Pos(p1,7+j*4);
			if(posx!=0XFF)gpsx->slmsg[slx].sn=NMEA_Str2num(p1+posx,&dx);	//õ
			else break;
			slx++;	   
		}   
 		p=p1+1;//лһGPGSVϢ
	}   
}
//GPGGAϢ   GPSλϢ
//gpsx:nmeaϢṹ
//buf:յGPSݻ׵ַ
void NMEA_GPGGA_Analysis(nmea_msg *gpsx,u8 *buf)
{
	u8 *p1,dx;			 
	u8 posx;    
	p1=(u8*)strstr((const char *)buf,"$GPGGA");
	posx=NMEA_Comma_Pos(p1,6);								//õGPS״̬
	if(posx!=0XFF)gpsx->gpssta=NMEA_Str2num(p1+posx,&dx);	
	posx=NMEA_Comma_Pos(p1,7);								//õڶλ
	if(posx!=0XFF)gpsx->posslnum=NMEA_Str2num(p1+posx,&dx); 
	posx=NMEA_Comma_Pos(p1,9);								//õθ߶
	if(posx!=0XFF)gpsx->altitude=NMEA_Str2num(p1+posx,&dx);  
}
//GPGSAϢ   ǰϢ
//gpsx:nmeaϢṹ
//buf:յGPSݻ׵ַ
void NMEA_GPGSA_Analysis(nmea_msg *gpsx,u8 *buf)
{
	u8 *p1,dx;			 
	u8 posx; 
	u8 i;   
	p1=(u8*)strstr((const char *)buf,"$GPGSA");
	posx=NMEA_Comma_Pos(p1,2);								//õλ
	if(posx!=0XFF)gpsx->fixmode=NMEA_Str2num(p1+posx,&dx);	
	for(i=0;i<12;i++)										//õλǱ
	{
		posx=NMEA_Comma_Pos(p1,3+i);					 
		if(posx!=0XFF)gpsx->possl[i]=NMEA_Str2num(p1+posx,&dx);
		else break; 
	}				  
	posx=NMEA_Comma_Pos(p1,15);								//õPDOPλþ
	if(posx!=0XFF)gpsx->pdop=NMEA_Str2num(p1+posx,&dx);  
	posx=NMEA_Comma_Pos(p1,16);								//õHDOPλþ
	if(posx!=0XFF)gpsx->hdop=NMEA_Str2num(p1+posx,&dx);  
	posx=NMEA_Comma_Pos(p1,17);								//õVDOPλþ
	if(posx!=0XFF)gpsx->vdop=NMEA_Str2num(p1+posx,&dx);  
}
//GPRMCϢ   ƼλϢ
//gpsx:nmeaϢṹ
//buf:յGPSݻ׵ַ
void NMEA_GPRMC_Analysis(nmea_msg *gpsx,u8 *buf)
{
	u8 *p1,dx;			 
	u8 posx;     
	u32 temp;	   
	float rs;  
	p1=(u8*)strstr((const char *)buf,"$GPRMC");
	posx=NMEA_Comma_Pos(p1,1);								//õUTCʱ
	if(posx!=0XFF)
	{
		temp=NMEA_Str2num(p1+posx,&dx)/NMEA_Pow(10,dx);	 	//õUTCʱ,ȥms
		gpsx->utc.hour=temp/10000;
		gpsx->utc.min=(temp/100)%100;
		gpsx->utc.sec=temp%100;	 	 
	}			  			  
	posx=NMEA_Comma_Pos(p1,3);								//õγ
	if(posx!=0XFF)
	{
		temp=NMEA_Str2num(p1+posx,&dx);		 	 
		gpsx->latitude=temp/NMEA_Pow(10,dx+2);	//õ
		rs=temp%NMEA_Pow(10,dx+2);				//õ'		 
		gpsx->latitude=gpsx->latitude*NMEA_Pow(10,5)+(rs*NMEA_Pow(10,5-dx))/60;//תΪ 
	}
	posx=NMEA_Comma_Pos(p1,4);								//γǱγ 
	if(posx!=0XFF)gpsx->nshemi=*(p1+posx);					 
 	posx=NMEA_Comma_Pos(p1,5);								//õ
	if(posx!=0XFF)
	{												  
		temp=NMEA_Str2num(p1+posx,&dx);		 	 
		gpsx->longitude=temp/NMEA_Pow(10,dx+2);	//õ
		rs=temp%NMEA_Pow(10,dx+2);				//õ'		 
		gpsx->longitude=gpsx->longitude*NMEA_Pow(10,5)+(rs*NMEA_Pow(10,5-dx))/60;//תΪ 
	}
	posx=NMEA_Comma_Pos(p1,6);								//
	if(posx!=0XFF)gpsx->ewhemi=*(p1+posx);		 
	posx=NMEA_Comma_Pos(p1,9);								//õUTC
	if(posx!=0XFF)
	{
		temp=NMEA_Str2num(p1+posx,&dx);		 				//õUTC
		gpsx->utc.date=temp/10000;
		gpsx->utc.month=(temp/100)%100;
		gpsx->utc.year=2000+temp%100;	 	 
	} 
}
//GPVTGϢ   ٶϢ
//gpsx:nmeaϢṹ
//buf:յGPSݻ׵ַ
void NMEA_GPVTG_Analysis(nmea_msg *gpsx,u8 *buf)
{
	u8 *p1,dx;			 
	u8 posx;    
	p1=(u8*)strstr((const char *)buf,"$GPVTG");							 
	posx=NMEA_Comma_Pos(p1,7);								//õ
	if(posx!=0XFF)
	{
		gpsx->speed=NMEA_Str2num(p1+posx,&dx);
		if(dx<3)gpsx->speed*=NMEA_Pow(10,3-dx);	 	 		//ȷ1000
	}
}  
//ȡNMEA-0183Ϣ
//gpsx:nmeaϢṹ
//buf:յGPSݻ׵ַ
void GPS_Analysis(nmea_msg *gpsx,u8 *buf)
{
	NMEA_GPGSV_Analysis(gpsx,buf);	//GPGSV
	NMEA_GPGGA_Analysis(gpsx,buf);	//GPGGA 	
	NMEA_GPGSA_Analysis(gpsx,buf);	//GPGSA
	NMEA_GPRMC_Analysis(gpsx,buf);	//GPRMC
	NMEA_GPVTG_Analysis(gpsx,buf);	//GPVTG
}

//GPSУͼ
//buf:ݻ׵ַ
//len:ݳ
//cka,ckb:У.
void Ublox_CheckSum(u8 *buf,u16 len,u8* cka,u8*ckb)
{
	u16 i;
	*cka=0;*ckb=0;
	for(i=0;i<len;i++)
	{
		*cka=*cka+buf[i];
		*ckb=*ckb+*cka;
	}
}
//UBLOX NEO-6ʱ
//interval:
//length:
//status::1,ߵƽЧ;0,ر;-1,͵ƽЧ.
void Ublox_Cfg_Tp(u32 interval,u32 length,signed char status)
{
	_ublox_cfg_tp *cfg_tp=(_ublox_cfg_tp *)USART_TX_BUF;
	cfg_tp->header=0X62B5;		//cfg header
	cfg_tp->id=0X0706;			//cfg tp id
	cfg_tp->dlength=20;			//Ϊ20ֽ.
	cfg_tp->interval=interval;	//,us
	cfg_tp->length=length;		//,us
	cfg_tp->status=status;	   	//ʱ
	cfg_tp->timeref=0;			//οUTC ʱ
	cfg_tp->flags=0;			//flagsΪ0
	cfg_tp->reserved=0;		 	//λΪ0
	cfg_tp->antdelay=820;    	//ʱΪ820ns
	cfg_tp->rfdelay=0;    		//RFʱΪ0ns
	cfg_tp->userdelay=0;    	//ûʱΪ0ns
	Ublox_CheckSum((u8*)(&cfg_tp->id),sizeof(_ublox_cfg_tp)-4,&cfg_tp->cka,&cfg_tp->ckb);
	while(DMA1_Channel4->CNDTR!=0);	//ȴͨ4   
	UART_DMA_Enable(DMA1_Channel4,sizeof(_ublox_cfg_tp));	//ͨdmaͳȥ
}
//UBLOX NEO-6ĸ	    
//measrate:ʱλΪmsٲС200ms5Hz
//reftime:οʱ䣬0=UTC Time1=GPS TimeһΪ1
void Ublox_Cfg_Rate(u16 measrate,u8 reftime)
{
	_ublox_cfg_rate *cfg_rate=(_ublox_cfg_rate *)USART_TX_BUF;
 	if(measrate<200)return;		//С200msֱ˳
 	cfg_rate->header=0X62B5;	//cfg header
	cfg_rate->id=0X0806;	 	//cfg rate id
	cfg_rate->dlength=6;	 	//Ϊ6ֽ.
	cfg_rate->measrate=measrate;//,us
	cfg_rate->navrate=1;		//ʣڣ̶Ϊ1
	cfg_rate->timeref=reftime; 	//οʱΪGPSʱ
	Ublox_CheckSum((u8*)(&cfg_rate->id),sizeof(_ublox_cfg_rate)-4,&cfg_rate->cka,&cfg_rate->ckb);
	while(DMA1_Channel4->CNDTR!=0);	//ȴͨ4   
	UART_DMA_Enable(DMA1_Channel4,sizeof(_ublox_cfg_rate));//ͨdmaͳȥ
}
