//================================================== 
// Texas Instruments Strictly Private 
// Copyright 1999, Texas Instruments Inc. 
//================================================== 
/*================================================== 
Device.c: routines to handle device record
//================================================*/
#define _DEVICE_
#include <Reg52.h>
#include <stddef.h>
#include "..\rom\types.h"
#include "..\rom\reg_stc1.h"
#include "..\rom\Mmap.h"
#include "..\rom\UsbEng.h"
#include "..\rom\usb.h"
#include "..\rom\RomBoot.h"
#include "..\rom\usbAudio.h"
#include "..\rom\usbHid.h"
#include "..\rom\usbDfu.h"
#include "..\rom\xdata.h"
#include "..\rom\devref.h"
#include "..\rom\ROmFunc.h"
#include "..\rom\hwMacro.h"
#include "delay.h"
#include "usbapp.h"
#include "devRCode.h"
#include "device.h"
#include "Codec.h"
#include "DevFuncMacro.h"
#include "Softpll.h"
#include "devdesc.h"
#include "DevXdata.h"
#include "gpio.h"
#include "device.h"
#include "spicomm.h"

#define TIMER1_PERIOD		60000			// 60 msec
#define TIMER1_UNITS		50

extern byte UsbAddress;

// Device record
DEV_DEVICE_STRUCT AppDevice;
DEV_SOFT_ACG_STRUCT AppDeviceSoftAcg;

// this is defined to save RAM space
bit AppDeviceSpkcurMute;
bit AppDeviceSpkpreMute;
bit AppDeviceMicReccurMute;
bit AppDeviceMicIncurMute;

// Reset & suspense Bit flag for App in App running
bit AppResetFlag;
bit AppSuspendFlag;

// for testing DFU DnLoad/Upload when target is DFU_TARGET_OTHER
byte *DevTestDfuDataPtr;

// touch screen control 
byte IndexI=0;
//bit PENIRQFlag = 0;

// Speaker Amp status
bit SpkEnaStatus;
bit SpkEnaStatusChanged;

// prototypes
void devInit();
void devSleepModeOn();
void devSleepModeOff();
void SetLedState(byte LedState);
void devCheckReset();
void spi_communication(unsigned int a, unsigned int b);
void generate_master_clock();
void IEP3_HID();
void OEP4_HID();
void ReadTS();

// For hardware guys to debug
#define RAM(ram_addr) (*((unsigned char xdata *) ram_addr))

// init TAC1020 global control register to enable XINT
#define GLOBCTL_INIT  LOW_POWER_DISABLE  | XINT_ENABLE

#ifdef _DEBUG_RESET_ 
sbit FalseReset = P3^0;
#endif

////////////////// ///////// DEVICE RECORD	/////////////////////////
/*-------------------------------------------------------------------
main(): This main is for device including the audio/hid/dfu
-------------------------------------------------------------------*/
void main()
{

	INIT_GPIO();            // initialize GPIO P1 and P3
	SPISS=1;		        // disable SPI 

	// initialize TSC2100 CODEC control registers
	INIT_TSCRESET();        // reset the TSC
	spi_communication(2, 2);
    delay(5);

	INIT_TSCPg11();	        // disable touchscreen
	spi_communication(3, 3);
    delay(5);
   	INIT_TSCPg12();	        // init page1 control regsters & enable TS
	spi_communication(6, 2);
    delay(5);
   	INIT_TSCPg21();   	    // init page2 audio control regsters
	spi_communication(8, 8);
    delay(5);
   	INIT_TSCPg22();         // initial more audio regs
	spi_communication(4, 2);
    delay(5);

#ifdef _DEBUG_RESET_ 
    FalseReset = 0;
#endif

    // Give the XRAM time to powered up as the MCU of the emulator is faster
#ifdef _EMULATOR_
    delay(80);	
    GLOBCTL = GLOBCTL_INIT;
	delay(100);
#else
    GLOBCTL = GLOBCTL_INIT;
#endif

    // ROM code using PDATA starting at 0xFA00
	P2 = 0xFA;
	RomRecord.state  = ROM_APP_RUNNING;	

	devInit();
	
	// using ROM DFU handler
	devRomFunction(ROM_INIT_DFU_STATE);
			
	// Take Codec out of reset
	CPTCTL = 0x01; 

   	// using ROM USB engine
	USBENGINE_EP0_SIZE = DEV_MAX_EP0_PKT;
	devRomFunction(ROM_ENG_USB_INIT);
   
    // Turn on status LED	
    SetLedState(LED_STATE_ON);

	// wait till codec inited
	while (AppDevice.configSetting == 0)

	AppResetFlag = FALSE;
	AppSuspendFlag = FALSE;
	SpkEnOut = 0;

	while(1)
	{  
	    if ( !DAV && !(PCRequest&Data2Request) )
		{
            ReadTS();	    
		}
        else
		{
			// For DFU mode
			if (RomRecord.state == ROM_DFU_MODE)
			{
    	    // Setup for reenumeration
        	// as device in DFU mode
				USBCTL = 0;
				USBFADR = 0;
				PARAMS_DFU_SETUP(DFU_TARGET_EEPROM, 0);
	        // this is for testing DFU_TARGET_OTHER	
		    // DevTestDfuDataPtr = (unsigned char xdata *)0x6000;
				devRomFunction(ROM_RUN_DFU_MODE);
			}
   			devCheckReset();

	    	// Handle SUSPENSE/RESUME
    	    if ((AppSuspendFlag == TRUE) && (AppResetFlag == FALSE))
   	    	{            
       	    	devSleepModeOn();
#ifndef _EMULATOR_
				PCON = 0x09;
#endif
   	  			while (AppSuspendFlag == TRUE);
      	 	    devSleepModeOff();		
			// Delay a bit (approx. 5 ms) to account for button debounce 
	        // if it was used to do a remote wake up. 
    		    delay(20);
       		}
			else
			{
				OEP4_HID();           // get HID report from PC & write to TSC2100
	   	    	IEP3_HID();           // read from TSC2100 & send HID to PC 
			}
		}
	}
	return;

	// Just a dummy code to force the compiler to keep 
	// DevFunctionEntryParser() in the final codes
	DevFunctionEntryParser(0, 0);

}

////////////////// ///////// DEVICE RECORD	/////////////////////////
/*-------------------------------------------------------------------
devInit(): initialize device
-------------------------------------------------------------------*/
void devInit()
{
    coCodecInited = FALSE;
	softPllInit();
}


/*-------------------------------------------------------------------
devInitSTC(): Initilize STC for the specific device operations
-------------------------------------------------------------------*/
void devInitSTC() 
{
	// ISO OUT EP # 1 
    OEPBSIZ1  = EP_BUFFER_SIZE(sizeof(Xdata.OutEp1XBuffer));
    OEPBBAX1  = EP_BASE_ADDR(ALIGNED_XDATA_ADDR(OutEp1XBuffer));
	OEPBBAY1  = 0;		// Y buffer is not used
	OEPCNF1   = 0x43; 	// ISO OUT EP, 4 BYTEs/sample 
	OEPDCNTX1 = 0x00; 	// Clear X data count
	OEPDCNTY1 = 0x00;   // Clear Y data count
	OEPCNF1  |= 0x80; 	// Enable the ISO OUT EP

	// ISO IN EP # 2 
    IEPBSIZ2 = EP_BUFFER_SIZE(sizeof(Xdata.InEp2XBuffer));
    IEPBBAX2 = EP_BASE_ADDR(ALIGNED_XDATA_ADDR(InEp2XBuffer));
	IEPBBAY2 =  0;		// Y buffer is not used
//#ifdef _STEREO_MIC_
//	IEPCNF2 = 0x43; 	// ISO IN EP, 4 BYTEs/sample 
//#else
	IEPCNF2 = 0x41; 	// ISO IN EP, 2 BYTEs/sample     
//#endif
	IEPDCNTX2 = 0x80; 	// Clear X data count
	IEPDCNTY2 = 0x80;   // Clear Y data count
    IEPCNF2  |= 0x80;   // enable the ISO IN EP

	// Interrupt Endpoint for HID - IN EP#3
    IEPBSIZ3 = EP_BUFFER_SIZE(sizeof(Xdata.InEp3));   
    IEPBBAX3 = EP_BASE_ADDR(ALIGNED_XDATA_ADDR(InEp3));
	IEPBBAY3 =  0;		// Y buffer is not used
	IEPCNF3   = 0x80; 	// ena interrupt IN EP & no interrupt
	IEPDCNTX3 = 0x80;   // set NACK bit & clear X data counter
	IEPDCNTY3 = 0x80;   // set NACK bit & clear Y data counter

	// Interrupt Endpoint for HID - OUT EP#4
    OEPBSIZ4  = EP_BUFFER_SIZE(sizeof(Xdata.OutEp4));
    OEPBBAX4  = EP_BASE_ADDR(ALIGNED_XDATA_ADDR(OutEp4));
	OEPBBAY4  = 0;		// Y buffer is not used
	OEPCNF4   = 0x84; 	// ena interrupt OUT EP & interrupt
	OEPDCNTX4 = 0x00; 	// Clear NACK bit & X data counter 
	OEPDCNTY4 = 0x00;   // Clear NACK bit & Y data counter 
 
	// Disable all unused Endpoints 
	IEPCNF1 = 0;
	IEPCNF4 = 0;
	IEPCNF5 = 0;
	IEPCNF6 = 0;
	IEPCNF7 = 0;
	OEPCNF2 = 0;
	OEPCNF3 = 0;
	OEPCNF5 = 0;
	OEPCNF6 = 0;
	OEPCNF7 = 0;

}

/*====================================================================
devSleepModeOff(): Take device hardare out of sleep mode.
=====================================================================*/
void devSleepModeOff()
{
#ifndef _DFU_DEV_ONLY_ 
    // Turn on codec
	coColdReset();

    // turn the power amp on	
	SpkEnOut = 0;
#endif

    // Turn on miscellaneous hardware
    if (AppDeviceSpkpreMute)
        SetLedState(LED_STATE_FLASH);
	else
		SetLedState(LED_STATE_ON);
}

/*====================================================================
devSleepModeOn(): Set device hardware to sleep mode, low power mode.
=====================================================================*/
void devSleepModeOn()
{
    SetLedState(LED_STATE_OFF);

#ifndef _DFU_DEV_ONLY_    
    // turn off power amp
	SpkEnOut = 1;

#endif
    // Set miscellaneous hardware to sleep mode
}

//
// SetLedState - Sets mute LED state
//
// LedState - LED state to set.
//
void SetLedState(byte LedState)
{
    switch(LedState)
    {
        case LED_STATE_ON:
            USBLed = LED_ON;
            break;

        case LED_STATE_OFF:
            USBLed = LED_OFF;
            break;

        default:
            break;
    
    }
}

/*--------------------------------------------------------------
devCheckReset: Check for USB Reset      
Method: If the USB RESET is true, then there is no SOF/PSOF 
interrupt. Otherwise, if the USB RESET is a spurious reset,
there will be SOF/PSOF interrupt as normally.
This routine based on the following:
- When there is a USB RESET interrupt the GlDevResetFlag 
is set to TRUE. 
- When there is a SOF or PSOF interrupt the GlDevResetFlag1 
is reset to FALSE. That means the SOF INT has to be enabled.
if GlDevResetFlag flag is set, the routine set GlDevResetFlag1
flag to TRUE and wait for at least more than two time frame,
2 ms to make sure that the SOF/PSOF interrupts happens if there
is any. It then checks the GlDevResetFlag1 flag. If the 
GlDevResetFlag1 flag is not reset, that means there is no 
SOF/PSOF interrupts. That means the USB Reset is real. In this
case the the USB RESET is handled as appropriate. Otherwise,
the USB RESET is spurious and there is no action.

Note: The delay should not be more than 10 ms as if the USB RESET
is real, due to specs, the device has to be ready to reponse
after 10 msec. 
--------------------------------------------------------------*/
void devCheckReset()
{
    if (AppResetFlag == TRUE)
    {
        USBFADR = 0;

#ifdef  _TAS1020_
        UsbAddress = 0;
#endif
            
        // Case we get USB RESET after SUSPEND and no RESUME
        if (AppSuspendFlag == TRUE)
        {
			AppSuspendFlag = FALSE;
        }
        AppResetFlag = FALSE;
    }
} 

/*===================================================================
spi_communication (unsigned int data_count, unsigned int word_count):
     Use the 4 GPIO pins to build an SPI serial port --
     total # of data is received/transmitted is "data_count"; and
     SPISS pin will go high every "word_count" # of data.   
===================================================================*/
void spi_communication (unsigned int data_count, unsigned int word_count)
{
	unsigned int i, j;
	for (i = 0; i < data_count;)// sending a group of data
	{
		SPISS = 0;				// make sure slave is selected
		for (j = 0; j < word_count; j++) // # of words (16bit)
		{
			data_received = 0;	// reset receive space
			data_to_send = write_data[i]; // load transmit space
			bit_count = 0;		// reset bit counter
			end_shift = 0;		// no bit shift yet
    		while (!end_shift)  // wait for all bits transmitted
			{
			  generate_master_clock();
			}
			read_data[i++] = data_received; // load received data
		}
  		SPISS = 1;				// diable slave selection
	}
}

/*===================================================================
generate_master_clock (): Rx/Tx a "MAX_BIT_COUNT"-bit long data.
===================================================================*/
void generate_master_clock ()
{
	if (!SPISCLK)
	{//drop SCLK, transmit mode
		SPISCLK = 1;
		SPIMOSI = data_to_send & 0x8000;
		data_to_send <<= 1;	//shift current MSB out
     }
	else
	{//raise clock, receive mode
		SPISCLK = 0;
		bit_count++;
		data_received <<= 1;
		data_received |= SPIMISO;
		if (bit_count >= MAX_BIT_COUNT)	//last bit has been shifted out
		{
			bit_count = 0;  // reset bit counter
			end_shift = 1;	// all MAX_BIT_COUNT bits have been shifted out
		}
	}
}

/*===================================================================
IEP3_HID(): Prepare Data to send from TSC2100 to PC through IEP3 HID
===================================================================*/
void IEP3_HID()
{
#ifdef _HID_

    if ( (PCCommand == PCRead) && !(PCRequest&RequestDone) )
	{
		switch (PCRequest)
		{
			case(ControlRegs):
			// read (6) TSC2100 Control Registers at page=0001b & addr=00h
			write_data[0] = 0x8800;
			spi_communication(7, 7);
			// put data to buffer for HID
    		for (IndexI = 1; IndexI < 7; IndexI++)    // store into buffer
    		{	
		  		Xdata.InEp3.HidReport.bReportItem[2*IndexI] =
										 		MSB(read_data[IndexI]);
		  		Xdata.InEp3.HidReport.bReportItem[2*IndexI+1] = 
												LSB(read_data[IndexI]);
			}
  			break;   

			case(AudioControlRegs):
			// read (7) TSC2100 Control Registers at page=0010b & addr=00h
			write_data[0] = 0x9000;
			spi_communication(8, 8);
			// put data to buffer for HID
		    for (IndexI = 1; IndexI < 8; IndexI++)    // store into buffer
		    {	
  				Xdata.InEp3.HidReport.bReportItem[2*IndexI] = 
												MSB(read_data[IndexI]);
		  		Xdata.InEp3.HidReport.bReportItem[2*IndexI+1] = 
												LSB(read_data[IndexI]);
			}
			// read (4) TSC2100 Control Registers at page=0010b & addr=1Bh
            write_data[0] = 0x9360;
			spi_communication(5, 5);
			// put data to buffer for HID
		    for (IndexI = 1; IndexI < 5; IndexI++)    // store into buffer
		    {	
  				Xdata.InEp3.HidReport.bReportItem[2*IndexI+14] = 
												MSB(read_data[IndexI]);
		  		Xdata.InEp3.HidReport.bReportItem[2*IndexI+15] = 
												LSB(read_data[IndexI]);
			}
			break;

			case(BoostFilter):
			// read (20) TSC2100 Boost Filter Parameters
			write_data[0] = 0x90E0;
			spi_communication(8, 8);
			// put data to buffer for HID
		    for (IndexI = 1; IndexI < 8; IndexI++) // store into buffer
		    {	
  				Xdata.InEp3.HidReport.bReportItem[2*IndexI] = 
												MSB(read_data[IndexI]);
		  		Xdata.InEp3.HidReport.bReportItem[2*IndexI+1] = 
												LSB(read_data[IndexI]);
			}
			write_data[0] = 0x91C0;
			spi_communication(8, 8);
			// put data to buffer for HID
		    for (IndexI = 1; IndexI < 8; IndexI++) // store into buffer
		    {	
  				Xdata.InEp3.HidReport.bReportItem[2*IndexI+14] = 
												MSB(read_data[IndexI]);
		  		Xdata.InEp3.HidReport.bReportItem[2*IndexI+15] = 
												LSB(read_data[IndexI]);
			}
			write_data[0] = 0x92A0;
			spi_communication(7, 7);
			// put data to buffer for HID
		    for (IndexI = 1; IndexI < 7; IndexI++) // store into buffer
		    {	
  				Xdata.InEp3.HidReport.bReportItem[2*IndexI+28] = 
												MSB(read_data[IndexI]);
		  		Xdata.InEp3.HidReport.bReportItem[2*IndexI+29] = 
												LSB(read_data[IndexI]);
			}
			break;

			case (Data1Request):
			// read & store touch screen x, y, z1, z2 data at pg0 start at addr=0x00
			write_data[0] = 0x8000;
			spi_communication(5, 5);                  // read X,Y,Z1,Z2
		   	for (IndexI = 1; IndexI < 5; IndexI++)    // store into buffer
			{	
				Xdata.InEp3.HidReport.bReportItem[2*IndexI]   = MSB(read_data[IndexI]);
				Xdata.InEp3.HidReport.bReportItem[2*IndexI+1] = LSB(read_data[IndexI]);
			}
			break;

			case (Data2Request):
 			write_data[0] = 0x8800;     // read current ADC reg
            spi_communication(2, 2);
 			CurrentADC = read_data[1]&0x03FF;
		// read BAT1
 			write_data[0] = 0x0800;     // put touch screen to host mode
 			write_data[1] = (0x1800|CurrentADC); // & BAT1
            spi_communication(2, 2);
			CounterT=20000;             // waiting for data avaliable
			while (DAV && CounterT)	{ CounterT -= 1; }
			if (CounterT)
			{
				write_data[0] = 0x80A0;// read BAT1
				spi_communication(2, 2);
 				Xdata.InEp3.HidReport.bReportItem[2] = MSB(read_data[1]);
 				Xdata.InEp3.HidReport.bReportItem[3] = LSB(read_data[1]);
			}
 		// read BAT2
 			write_data[0] = 0x0800;     // put touch screen to host mode
 			write_data[1] = (0x1C00|CurrentADC); // & BAT2
            spi_communication(2, 2);
			CounterT=20000;             // waiting for data avaliable
			while (DAV && CounterT)	{ CounterT -= 1; }
			if (CounterT)
			{
				write_data[0] = 0x80C0;// read BAT2
				spi_communication(2, 2);
 				Xdata.InEp3.HidReport.bReportItem[4] = MSB(read_data[1]);
 				Xdata.InEp3.HidReport.bReportItem[5] = LSB(read_data[1]);
			}
		// read AUX1
 			write_data[0] = 0x9000;     // Read back audio MICIN
            spi_communication(2, 2);
			if ( (read_data[1] & 0x3000) == 0 )
			{
 			write_data[0] = 0x0800;     // put touch screen to host mode
 			write_data[1] = (0x2000|CurrentADC); // & AUX
            spi_communication(2, 2);
			CounterT=20000;             // waiting for data avaliable
			while (DAV && CounterT)	{ CounterT -= 1; }
			if (CounterT)
			{
				write_data[0] = 0x80E0;// read AUX
				spi_communication(2, 2);
 				Xdata.InEp3.HidReport.bReportItem[6] = MSB(read_data[1]);
 				Xdata.InEp3.HidReport.bReportItem[7] = LSB(read_data[1]);
			}
			}
    	 // read TEMP1 
 			write_data[0] = 0x0800;     // put touch screen to host mode
 			write_data[1] = (0x2800|CurrentADC);  // & TEMP1 mode
            spi_communication(2, 2);
			CounterT=20000;             // waiting for data avaliable
			while (DAV && CounterT)	{ CounterT -= 1; }
			if (CounterT)
			{
				write_data[0] = 0x8120; // read TEMP1 
				spi_communication(2, 2);
				Xdata.InEp3.HidReport.bReportItem[10] = MSB(read_data[1]);
				Xdata.InEp3.HidReport.bReportItem[11] = LSB(read_data[1]);
			}
     	 // read TEMP2
 			write_data[0] = 0x0800;     // put touch screen to host mode
 			write_data[1] = (0x3000|CurrentADC);  // & TEMP2 mode
            spi_communication(2, 2);
			CounterT=20000;             // waiting for data avaliable
			while (DAV && CounterT)	{ CounterT -= 1; }
			if (CounterT)
			{
				write_data[0] = 0x8140;// read TEMP2
				spi_communication(2, 2);
				Xdata.InEp3.HidReport.bReportItem[12] = MSB(read_data[1]);
				Xdata.InEp3.HidReport.bReportItem[13] = LSB(read_data[1]);
			}
			break;

			default:
			PCCommand |= PCRequestError; 
			break;
		}
		// send data to PC through USP HID
		PCRequest |= RequestDone;
		Xdata.InEp3.HidReport.bReportItem[0] = PCCommand;
		Xdata.InEp3.HidReport.bReportItem[1] = PCRequest;
		while (!(IEPDCNTX3&0x80)) ;
		IEPDCNTX3 = sizeof(Xdata.InEp3.HidReport);
	}

#endif
}

/*===================================================================
OEP4_HID(): Download OEP4 HID data from PC to TSC2100
===================================================================*/
void OEP4_HID()
{
#ifdef _HID_

	if ( (PCCommand == PCWrite) && !(PCRequest & RequestDone) )
	{		 							// if PC writes to TSC2100
		switch (PCRequest)              // 
		{
			case(ControlRegs):
            if ( Xdata.OutEp4.HidOReport.bReportOut[10] == 0xBB )
			{
			INIT_TSCRESET();        // reset the TSC
			spi_communication(2, 2);
			}
            else
            {
			// move touch screen command data (from PC) to TSC2100
			write_data[0] = 0x0800;     // disable touch screen
			write_data[1] = DisableTS;	
			write_data[2] = 0x08A0;     // write to CONFIG: pg1/addr0x05
			write_data[3] = ((Xdata.OutEp4.HidOReport.bReportOut[12]<<8)|
 			            	  Xdata.OutEp4.HidOReport.bReportOut[13]);
		    write_data[4] = 0x0860;     // write to REF: pg1/addr0x03
			write_data[5] = ((Xdata.OutEp4.HidOReport.bReportOut[8]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[9]);
			write_data[6] = 0x0820;     // write to STATUS: pg1/addr0x01
			write_data[7] = ((Xdata.OutEp4.HidOReport.bReportOut[4]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[5]);
			spi_communication(8, 2);
			
 			write_data[0] = 0x0800;     // put touch screen to host mode
 			write_data[1] = 0x07FE;
 			write_data[2] = 0x0800;     // write to TS ADC: pg1/addr0x00
			write_data[3] = ((Xdata.OutEp4.HidOReport.bReportOut[2]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[3]);
			spi_communication(4, 2);
            }
			break;

			case(AudioControlRegs):
			// move audio command data (from PC) to TSC2100
		    write_data[0] = 0x1000;     // write to audio control reg: pg2/addr0x00
			write_data[1] = ((Xdata.OutEp4.HidOReport.bReportOut[2]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[3]);
			write_data[2] = ((Xdata.OutEp4.HidOReport.bReportOut[4]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[5]);
			write_data[3] = ((Xdata.OutEp4.HidOReport.bReportOut[6]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[7]);
			write_data[4] = ((Xdata.OutEp4.HidOReport.bReportOut[8]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[9]);
			write_data[5] =	((Xdata.OutEp4.HidOReport.bReportOut[10]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[11]);
			write_data[6] = ((Xdata.OutEp4.HidOReport.bReportOut[12]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[13]);
			write_data[7] = ((Xdata.OutEp4.HidOReport.bReportOut[14]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[15]);
			spi_communication(8, 8);

		    write_data[0] = 0x1360;     // write to PLL reg1: pg2/addr0x1B
			write_data[1] = ((Xdata.OutEp4.HidOReport.bReportOut[16]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[17]);
			write_data[2] = ((Xdata.OutEp4.HidOReport.bReportOut[18]<<8)|
			            	  Xdata.OutEp4.HidOReport.bReportOut[19]);
			write_data[3] = ((Xdata.OutEp4.HidOReport.bReportOut[20]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[21]);
			write_data[4] = ((Xdata.OutEp4.HidOReport.bReportOut[22]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[23]);
			spi_communication(5, 5);
		    break;

			case(BoostFilter):          // write to boost filter
			write_data[0] = 0x10E0;
			write_data[1] = ((Xdata.OutEp4.HidOReport.bReportOut[2]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[3]);
			write_data[2] = ((Xdata.OutEp4.HidOReport.bReportOut[4]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[5]);
			write_data[3] = ((Xdata.OutEp4.HidOReport.bReportOut[6]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[7]);
			write_data[4] = ((Xdata.OutEp4.HidOReport.bReportOut[8]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[9]);
			write_data[5] = ((Xdata.OutEp4.HidOReport.bReportOut[10]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[11]);
			write_data[6] = ((Xdata.OutEp4.HidOReport.bReportOut[12]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[13]);
			write_data[7] = ((Xdata.OutEp4.HidOReport.bReportOut[14]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[15]);
			spi_communication(8, 8);

			write_data[0] = 0x11C0;
			write_data[1] = ((Xdata.OutEp4.HidOReport.bReportOut[16]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[17]);
			write_data[2] = ((Xdata.OutEp4.HidOReport.bReportOut[18]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[19]);
			write_data[3] = ((Xdata.OutEp4.HidOReport.bReportOut[20]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[21]);
			write_data[4] = ((Xdata.OutEp4.HidOReport.bReportOut[22]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[23]);
			write_data[5] = ((Xdata.OutEp4.HidOReport.bReportOut[24]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[25]);
			write_data[6] = ((Xdata.OutEp4.HidOReport.bReportOut[26]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[27]);
			write_data[7] = ((Xdata.OutEp4.HidOReport.bReportOut[28]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[29]);
			spi_communication(8, 8);

			write_data[0] = 0x12A0;
			write_data[1] = ((Xdata.OutEp4.HidOReport.bReportOut[30]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[31]);
			write_data[2] = ((Xdata.OutEp4.HidOReport.bReportOut[32]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[33]);
			write_data[3] = ((Xdata.OutEp4.HidOReport.bReportOut[34]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[35]);
			write_data[4] = ((Xdata.OutEp4.HidOReport.bReportOut[36]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[37]);
			write_data[5] = ((Xdata.OutEp4.HidOReport.bReportOut[38]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[39]);
			write_data[6] = ((Xdata.OutEp4.HidOReport.bReportOut[40]<<8)|
			             	  Xdata.OutEp4.HidOReport.bReportOut[41]);
			spi_communication(7, 7);
			break;

			default:
			break;
		}
		PCRequest |= RequestDone;       // set RequestDone flag
	}

#endif
}

/*===================================================================
ReadTS(): Read touch screen
===================================================================*/
void ReadTS()
{
#ifdef _HID_

	// read & store touch screen x, y, z1, z2 data at pg0 start at addr=0x00
	write_data[0] = 0x8000;
	spi_communication(5, 5);                  // read X,Y,Z1,Z2
   	for (IndexI = 1; IndexI < 5; IndexI++)    // store into buffer
	{	
		Xdata.InEp3.HidReport.bReportItem[2*IndexI]   = MSB(read_data[IndexI]);
		Xdata.InEp3.HidReport.bReportItem[2*IndexI+1] = LSB(read_data[IndexI]);
	}
	Xdata.InEp3.HidReport.bReportItem[0] = PCCommand;
	Xdata.InEp3.HidReport.bReportItem[1] = Data1Request | RequestDone;
	while (!(IEPDCNTX3&0x80)) ;
	IEPDCNTX3 = sizeof(Xdata.InEp3.HidReport);

#endif
}

