//==================================================
// Texas Instruments Strictly Private
// Copyright 1999, Texas Instruments Inc.
//==================================================
/*==================================================
Codec.c: routines for prgramming the AC 97 Codec
Note: Data values are provided by the device record
//================================================*/
#include <Reg52.h>
#include "..\rom\types.h"
#include "..\rom\Reg_stc1.h"
#include "..\rom\usbdfu.h"
#include "usbapp.h"
#include "device.h"
#include "softpll.h"
#include "delay.h"
#include "Codec.h"
#include "gpio.h"

bit coCodecInited = 0;

/*===================================================================
coInitCodec(): initialize the codec
===================================================================*/
void coInitCodec()
{

    if (!coCodecInited)
    {

    USBIMSK &= ~0x10;
    softPllInit();
    USBIMSK |= 0x10;

    // configure DMA       
	DMATSH0  = 0x40;     // 2 BYTEs per time slot 
	DMATSL0  = 0x03;     // Slots 0&1
	DMACTL0  = 0x01;     // Out EP1 to C-port 
    DMACTL0 |= 0x80;     // enable OEP1
    
	DMATSH1  = 0x40;     // 2 BYTEs per time slot
//#ifdef _STEREO_MIC_
//    DMATSL1  = 0x05;     // Slots 0&1
//#else
   DMATSL1  = 0x01;     // Slots 0
//#endif
	DMACTL1  = 0x0A;     // In EP2 from C-port      
    DMACTL1 |= 0x80;     // enable EP2 from C-port  

    // disable C-port  
    GLOBCTL &= ~CODEC_PORT_ENABLE;
    // Configure the C-port   
    CPTCNF1 = 0x0C;     // I2S mode4
    CPTCNF2 = 0xCD;     // 16-bit per time slot  
    CPTCNF3 = 0xAC;	    // byte inverse & 1clk delay
    CPTCNF4 = 0x03;     
    // Enable C-port
    GLOBCTL |= CODEC_PORT_ENABLE;

    }    
    coCodecInited = TRUE;
}

/*===================================================================
coColdReset(): Warm reset Codec
===================================================================*/
void coColdReset()
{

    CPTCTL = 0x00;
	
	// Turn on Codec
    CPTCTL = 0x01;    
    coInitCodec();
}

