//=============================================================================
// GPIO.H
//
// This module contains bit definitions for GPIO pins.
//
// Texas Instruments Strictly Private 
// Copyright 2001, Texas Instruments Inc. 
//============================================================================= 
#ifndef _GPIO_H
#define _GPIO_H

// GPIO Port1 definitions
sbit SPIMISO	= P1^7;	//input
sbit SPIMOSI	= P1^6;	//output
sbit SPISS	    = P1^5;	//output
sbit SPISCLK	= P1^4; //output
sbit SpkEnOut   = P1^2;

// GPIO Port3 definitions
sbit DAV        = P3^1; // touch screen PENTDAVZ interrupt req
sbit USBLed     = P3^0; // program running LED

#define INIT_GPIO()		SPIMISO = 1;                      \
                        SPIMOSI = SPISS = SPISCLK = 0;    \
                        DAV   = 1;                        \
                        SpkEnOut = USBLed = 0

#define LED_ON      	0
#define LED_OFF     	1

// USB HID PC Command/Request Bytes Definition
// MSB - PC command
#define PCRequestError		0x80
#define PCRead				0x01
#define PCWrite 			0x00
// LSB - PC Request
#define RequestDone         0x10
#define ControlRegs			0x01
#define AudioControlRegs	0x02
#define BoostFilter			0x04
#define Data2Request		0x40
#define Data1Request		0x80

#endif
