#include "APC.h"

uint32_t a;
uint32_t b;
uint32_t c;
uint32_t d;

void APC_Task(void *arg)
{
    APC_Init();
    TMRA_Start(CM_TMRA_3);
    for (;;)
    {
			  vTaskDelay(100UL / portTICK_RATE_MS);
    }
}

void APC_Init(void)
{
	  GPIO_SetFunc(GPIO_PORT_C, GPIO_PIN_04 | GPIO_PIN_05, GPIO_FUNC_5);//PC4PC5Ź
	
	  FCG_Fcg2PeriphClockCmd(FCG2_PERIPH_TMRA_3, ENABLE);//TMRAʱ
	  FCG_Fcg0PeriphClockCmd(FCG0_PERIPH_AOS, ENABLE);//AOSʱ
	
    stc_tmra_init_t stcTmraInit;
    TMRA_StructInit(&stcTmraInit);//Ĭϳʼֵ
    stcTmraInit.sw_count.u8ClockDiv = TMRA_CLK_DIV128;//ʱӷƵ  390625hz  0.00000256s
    TMRA_Init(CM_TMRA_3, &stcTmraInit);//ʼ
	
    TMRA_SetFunc(CM_TMRA_3, TMRA_CH7, TMRA_FUNC_CAPT);//TMRΪ벶
	  TMRA_SetFunc(CM_TMRA_3, TMRA_CH8, TMRA_FUNC_CAPT);//TMR
	
	  AOS_SetTriggerEventSrc(AOS_TMRA_0, EVT_SRC_TMRA_3_CMP);//TMR3¼Դ = TMRA3ıȽ¼
	
    TMRA_HWCaptureCondCmd(CM_TMRA_3, TMRA_CH7, TMRA_CAPT_COND_EVT, ENABLE);//ͨ7 = ¼
	  TMRA_HWCaptureCondCmd(CM_TMRA_3, TMRA_CH8, TMRA_CAPT_COND_PWM_RISING, ENABLE);//ͨ8 = 
	  //TMRA_HWStopCondCmd(CM_TMRA_3, TMRA_STOP_COND_EVT, ENABLE);
	  //TMRA_HWClearCondCmd(CM_TMRA_3, TMRA_CLR_COND_EVT, ENABLE);//TMRA_HCONR¼ѡĴHCLE2λ = TMRA_TRGSEL0Ĵָ¼
	  TMRA_EventCmd(CM_TMRA_3, TMRA_EVT_CMP_CH8, ENABLE);//¼Ϊͨ8

    stc_irq_signin_config_t stcIrq;
    stcIrq.enIntSrc    = INT_SRC_TMRA_3_CMP;    //жԴΪTMRA3Ƚ
    stcIrq.enIRQn      = TMRA_INT_IRQn_H;       //жϺ
    stcIrq.pfnCallback = &TMRA_IrqCallback_CH7; //жϺ
    INTC_IrqSignIn(&stcIrq);
    NVIC_ClearPendingIRQ(stcIrq.enIRQn);
    NVIC_SetPriority(stcIrq.enIRQn, DDL_IRQ_PRIO_03);//жȼ
    NVIC_EnableIRQ(stcIrq.enIRQn);
    TMRA_IntCmd(CM_TMRA_3, TMRA_INT_CMP_CH7, ENABLE); //ʹָж
		
    stcIrq.enIntSrc    = INT_SRC_TMRA_3_CMP;   //жԴΪTMRA3Ƚ
    stcIrq.enIRQn      = TMRA_INT_IRQn_L;      //жϺ
    stcIrq.pfnCallback = &TMRA_IrqCallback_CH8;//жϺ
    INTC_IrqSignIn(&stcIrq);
    NVIC_ClearPendingIRQ(stcIrq.enIRQn);
    NVIC_SetPriority(stcIrq.enIRQn, DDL_IRQ_PRIO_03);//жȼ
    NVIC_EnableIRQ(stcIrq.enIRQn);
    TMRA_IntCmd(CM_TMRA_3, TMRA_INT_CMP_CH8, ENABLE); //ʹָж
}

void TMRA_IrqCallback_CH7(void)
{
    TMRA_ClearStatus(CM_TMRA_3, TMRA_FLAG_CMP_CH7);
	  a = TMRA_GetCompareValue(CM_TMRA_3, TMRA_CH7);

}

void TMRA_IrqCallback_CH8(void)
{
    TMRA_ClearStatus(CM_TMRA_3, TMRA_FLAG_CMP_CH8);
	  b = TMRA_GetCompareValue(CM_TMRA_3, TMRA_CH8);

}
