
/**
  ******************************************************************************
  * @file		NandFlash.c
  * @brief		NandFlash ԴļûӦֱӵøļеĺ .
  * @version  	1.0
  ******************************************************************************
  */

#include "platform.h"

/**
  * @defgroup 	NandFlashPrivate
  * @brief 		NandFlash ڲ .
  * @{
  */

/**
  ******************************************************************************	
  * @brief  	Ƭѡ .
  * @param  	 
  * @retval 	
  * @note		
  ******************************************************************************
  */
static void NFChipSel(void)
{
	GPIO_BitWriteSafe(GPIO2, PIN_NUM_NAND_CE, 0);
}

/**
  ******************************************************************************	
  * @brief  	ȡƬѡ .
  * @param  	 
  * @retval 	
  * @note		
  ******************************************************************************
  */
static void NFChipDesel(void)
{
	GPIO_BitWriteSafe(GPIO2, PIN_NUM_NAND_CE, 1);	
}

/**
  ******************************************************************************	
  * @brief  	ȴNandFlashڲ .
  * @param  	TimeOut : ʱѭ 
  * @retval 	ο NF_STATUS_TypeDef  (NandFlash.h)
  * @note		RBű߱ʾڲ
  ******************************************************************************
  */
static NF_STATUS_TypeDef NFWaitBusy(u32 TimeOut)
{		
	while((!(GPIO_BitRead(GPIO2, PIN_NUM_NAND_RB))) && (--TimeOut));	
								 	
	return TimeOut ? NF_STATUS_SUCCESS : NF_STATUS_TIME_OUT;
										//TimeOut 0 ʾûгʱ
}

/**
  * @}
  */


/**
  * @addtogroup 	NandFlashPublic
  * @{
  */ 

/**
  ******************************************************************************	
  * @brief  	ĳҳжȡֽ .
  * @param  	Buffer : ַ 
  * @param  	PageAddr : ҳַ
  * @param  	ByteAddr : ҳֽڵַ
  * @param  	NumToRead : Ҫȡֽ
  * @retval 	ο NF_STATUS_TypeDef  (NandFlash.h) 			
  * @note		ҳָ528ֽҳȡݱͬһҳ
  ******************************************************************************
  */
NF_STATUS_TypeDef 
NFReadPage(u8 * Buffer, u32 PageAddr, u32 ByteAddr, u32 NumToRead)
{
	NF_STATUS_TypeDef status;
	
	if(PageAddr >= NF_PAGE_COUNT)  				//ҳַΧ
	{
		return NF_STATUS_PAGE_OUT;	
	}

	if((ByteAddr + NumToRead) > (NF_PAGE_SIZE + NF_SPARE_SIZE))
	{											//ȡݳҳ
		return NF_STATUS_BYTE_OUT;	
	}
		
	NFChipSel();								//Ƭѡ		

	if(ByteAddr & NF_AREA_C_MASK)				//ֽڵַλ C
	{
		NFCmdReg = NF_CMD_ADDR_AREA_C;
	}
	else if(ByteAddr & NF_AREA_B_MASK)			//ֽڵַλ B
	{
		NFCmdReg = NF_CMD_ADDR_AREA_B;
	}
	else							 			//ֽڵַλ A
	{
		NFCmdReg = NF_CMD_ADDR_AREA_A;
	}
	
	NFAddrReg = (u8)ByteAddr;					//͵ַ			
	NFAddrReg = (u8)PageAddr; 
	NFAddrReg = (u8)(PageAddr >> 8);
	NFAddrReg = (u8)(PageAddr >> 16);
	
	status = NFWaitBusy(NF_TIME_OUT_READ);		//æ
	
	if(status == NF_STATUS_SUCCESS)
	{
		while(NumToRead--)			 			//
		{
			*(Buffer++) = NFDataReg;
		}
		status = NFWaitBusy(NF_TIME_OUT_READ);	//æ
	}

	NFChipDesel(); 								//ȡƬѡ

	return status;
}

/**
  ******************************************************************************	
  * @brief  	ĳҳдֽ .
  * @param  	Buffer : ַ 
  * @param  	PageAddr : ҳַ
  * @param  	ByteAddr : ҳֽڵַ
  * @param  	NumToRead : Ҫдֽ
  * @retval 	ο NF_STATUS_TypeDef  (NandFlash.h) 
  * @note		ҳָ528ֽҳдݱͬһҳ
  ******************************************************************************
  */
NF_STATUS_TypeDef 
NFWritePage(u8 * Buffer, u32 PageAddr, u32 ByteAddr, u32 NumToWrite)
{
	NF_STATUS_TypeDef status;

	if(PageAddr >= NF_PAGE_COUNT)  				//ҳַΧ
	{
		return NF_STATUS_PAGE_OUT;	
	}

	if((ByteAddr + NumToWrite) > (NF_PAGE_SIZE + NF_SPARE_SIZE))
	{											//ȡݳҳ
		return NF_STATUS_BYTE_OUT;	
	}
		
	NFChipSel();								//Ƭѡ		

	if(ByteAddr & NF_AREA_C_MASK)				//ֽڵַλ C
	{
		NFCmdReg = NF_CMD_ADDR_AREA_C;
	}
	else if(ByteAddr & NF_AREA_B_MASK)			//ֽڵַλ B
	{
		NFCmdReg = NF_CMD_ADDR_AREA_B;
	}
	else							 			//ֽڵַλ A
	{
		NFCmdReg = NF_CMD_ADDR_AREA_A;
	}

	NFCmdReg = NF_CMD_PROG_TRUE_1;

	NFAddrReg = (u8)ByteAddr;					//͵ַ			
	NFAddrReg = (u8)PageAddr; 
	NFAddrReg = (u8)(PageAddr >> 8);
	NFAddrReg = (u8)(PageAddr >> 16);

	while(NumToWrite--)			 				//
	{
		NFDataReg = *(Buffer++);
	}

	NFCmdReg = NF_CMD_PROG_TRUE_2; 				

	status = NFWaitBusy(NF_TIME_OUT_PROG);		//æ
	
	if(status == NF_STATUS_SUCCESS)
	{
		NFCmdReg = NF_CMD_READ_STATUS;			//ȡ״̬
		status = (NFDataReg & NF_ERROR_PROG_MASK) ? NF_STATUS_PROG_ERROR \
												  : NF_STATUS_SUCCESS;
	}	

	NFChipDesel(); 								//ȡƬѡ

	return status;
}

/**
  ******************************************************************************	
  * @brief  	 .
  * @param  	BlockAddr : ַ
  * @retval 	ο NF_STATUS_TypeDef  (NandFlash.h) 
  * @note		
  ******************************************************************************
  */
NF_STATUS_TypeDef NFErase(u32 BlockAddr)
{
	NF_STATUS_TypeDef status;

	if(BlockAddr >= NF_BLOCK_COUNT)  			//ַΧ
	{
		return NF_STATUS_BLOCK_OUT;	
	}
		
	NFChipSel();								//Ƭѡ		

	NFCmdReg = NF_CMD_ERASE_1;
	
	BlockAddr <<= NF_PAGE_PER_BLOCK_BIT;		
	NFAddrReg = (u8)BlockAddr ; 
	NFAddrReg = (u8)(BlockAddr >> 8);
	NFAddrReg = (u8)(BlockAddr >> 16);

	NFCmdReg = NF_CMD_ERASE_2; 				

	status = NFWaitBusy(NF_TIME_OUT_ERASE);		//æ
	
	if(status == NF_STATUS_SUCCESS)
	{
		NFCmdReg = NF_CMD_READ_STATUS;			//ȡ״̬
		status = (NFDataReg & NF_ERROR_ERASE_MASK) ? NF_STATUS_ERASE_ERROR \
												   : NF_STATUS_SUCCESS;
	}	

	NFChipDesel(); 								//ȡƬѡ

	return status;	
}
/**
  ******************************************************************************	
  * @brief  	ȡID .
  * @param  	Buffer : ַ,ָ4ֽڵĻ 
  * @retval 	ο NF_STATUS_TypeDef  (NandFlash.h)
  * @note		
  ******************************************************************************
  */
NF_STATUS_TypeDef NFReadID(u8 * Buffer)
{	
	NF_STATUS_TypeDef status;	
	u32 i = 4;
	
	NFChipSel();								//Ƭѡ
	
	NFCmdReg = NF_CMD_READ_ID;
	NFAddrReg = 0;					
	while(i--)
	{
		*(Buffer++) = NFDataReg;
	}
	
	NFChipDesel(); 								//ȡƬѡ
	
	status = NF_STATUS_SUCCESS;
	
	return status;
}

/**
  ******************************************************************************	
  * @brief  	λ .
  * @param  	 
  * @retval 	ο NF_STATUS_TypeDef  (NandFlash.h)
  * @note		
  ******************************************************************************
  */
NF_STATUS_TypeDef NFReset(void)
{
	NF_STATUS_TypeDef status;
	
	NFChipSel();								//Ƭѡ
	
	NFCmdReg = NF_CMD_RESET;
	
	status = NFWaitBusy(NF_TIME_OUT_RESET);		//æ
	
	NFChipDesel();
	
	return status; 	
}

/**
  * @}
  */
  
