
#ifndef _NAND_FLASH_H
#define _NAND_FLASH_H

/**
  ******************************************************************************
  * @file		NandFlash.h
  * @brief		NandFlash ͷļ .
  * @version  	1.0
  ******************************************************************************
  */

/**
  * @defgroup 	NandFlashPrivate
  * @brief 		NandFlash ڲ .
  * @{
  */
//NandFlash Ӳ
#define NF_PAGE_SIZE			512		/**< ҳС */
#define NF_PAGE_SIZE_BIT		9		/**< ҳС 2Ϊ׵Ķ */

#define NF_SPARE_SIZE			16		/**< ÿҳĸС */
#define NF_SPARE_SIZE_BIT		4		/**< ÿҳĸС 2Ϊ׵Ķ */

#define NF_PAGE_PER_BLOCK		32		/**< ÿҳ */
#define NF_PAGE_PER_BLOCK_BIT	5		/**< ÿҳ 2Ϊ׵Ķ */

#define NF_BLOCK_PER_PLANE		1024	/**< ÿƽĿ */
#define NF_BLOCK_PER_PLANE_BIT	10		/**< ÿƽĿ 2Ϊ׵Ķ */

#define NF_PLANE_PER_DEVICE		4		/**< ÿ豸ƽ */
#define NF_PLANE_PER_DEVICE_BIT	2		/**< ÿ豸ƽ 2Ϊ׵Ķ */

#define NF_PAGE_COUNT 			(NF_PLANE_PER_DEVICE * NF_BLOCK_PER_PLANE \
							   * NF_PAGE_PER_BLOCK)
							   			/**< ҳ */

#define NF_BLOCK_COUNT 			(NF_PLANE_PER_DEVICE * NF_BLOCK_PER_PLANE)

										/**< ܿ */
										
#define NF_TIME_OUT_READ		12000	/**< ʱ : 12us */
#define NF_TIME_OUT_PROG		200000	/**< дʱ : 200us */
//#define NF_TIME_OUT_PROG		2000000	/**< дʱ : 200us */
#define NF_TIME_OUT_ERASE		2000000	/**< ʱ : 2ms */
//#define NF_TIME_OUT_ERASE		20000000	/**< ʱ : 2ms */
#define NF_TIME_OUT_RESET		500000	/**< λʱ : 500us */

//NandFlash ҳ
#define NF_AREA_B_MASK			0x00000100
#define NF_AREA_C_MASK			0x00000200

//NandFlash ״̬
#define NF_ERROR_PROG_MASK		0x01	/**< ҳ  */
#define NF_ERROR_ERASE_MASK		0x01	/**<   */
#define NF_ERROR_BUSY_MASK		0x40	/**< 1ready  0 busy  */

//SPARE AREA ASSIGNMENT
#define NF_SPARE_BI				517		/**< Ϣλ */

//NandFlash ӿڼĴ
#define NFDataReg	(*(vu8*)0x66800000) /**< NandFlash ݼĴ */
#define	NFCmdReg	(*(vu8*)0x66A00000)	/**< NandFlash Ĵ */
#define NFAddrReg	(*(vu8*)0x66C00000)	/**< NandFlash ַĴ */

//NandFlash 
#define NF_CMD_RESET 			0xFF	/**< λ */
#define NF_CMD_READ_ID 			0x90	/**< ȡID */
#define NF_CMD_READ_STATUS 		0x70	/**< ȡ״̬ */
      
#define NF_CMD_ADDR_AREA_A 		0x00	/**< ַA */
#define NF_CMD_ADDR_AREA_B 		0x01	/**< ַB */
#define NF_CMD_ADDR_AREA_C 		0x50	/**< ַC */

#define NF_CMD_PROG_TRUE_1 		0x80	/**< ҳ̣TRUEһ */
#define NF_CMD_PROG_TRUE_2 		0x10	/**< ҳ̣TRUEڶ */

#define NF_CMD_ERASE_1	 		0x60	/**< һ */
#define NF_CMD_ERASE_2	 		0xD0	/**< ڶ */

/**
  * @}
  */

/**
  * @addtogroup 	NandFlashPublic
  * @{
  */ 
/** NandFlash ִз״̬ */        
typedef enum 
{
	NF_STATUS_SUCCESS	= 0,			/**< ִгɹ */
	NF_STATUS_PAGE_OUT,					/**< ҳַΧ */
	NF_STATUS_BYTE_OUT,					/**< ֽڵַֽ ҳΧ */
	NF_STATUS_BLOCK_OUT,				/**< ַΧ  */
	NF_STATUS_PROG_ERROR,				/**< ҳ̳ */
	NF_STATUS_ERASE_ERROR,				/**<  */
	NF_STATUS_TIME_OUT					/**< ʱ */
}NF_STATUS_TypeDef;

/**
  * @}
  */
 
NF_STATUS_TypeDef NFReset(void);
NF_STATUS_TypeDef NFReadID(u8 * Buffer);
NF_STATUS_TypeDef NFReadPage(u8 * Buffer, u32 PageAddr, u32 ByteAddr, u32 NumToRead);
NF_STATUS_TypeDef NFWritePage(u8 * Buffer, u32 PageAddr, u32 ByteAddr, u32 NumToWrite);
NF_STATUS_TypeDef NFErase(u32 BlockAddr);


#endif 	//#ifndef _NAND_FLASH_H
