/*-----------------------------------------------------------------------*/
/* Low level disk I/O module skeleton for FatFs     (C)ChaN, 2007        */
/*-----------------------------------------------------------------------*/
/* by grqd_xp                                                            */
/* This is a stub disk I/O module that acts as front end of the existing */
/* disk I/O modules and attach it to FatFs module with common interface. */
/*-----------------------------------------------------------------------*/


#include <string.h>
#include "platform.h"
#include "diskio.h"


/*-----------------------------------------------------------------------*/
/* Correspondence between physical drive number and physical drive.      */
/* Note that Tiny-FatFs supports only single drive and always            */
/* accesses drive number 0.                                              */



/*-----------------------------------------------------------------------*/
/* Inidialize a Drive                                                    */

DSTATUS disk_initialize (
	BYTE drv				/* Physical drive nmuber (0..) */
)
{	
	FTL_Init();
	
	return RES_OK;
}

/*-----------------------------------------------------------------------*/
/* Return Disk Status                                                    */

DSTATUS disk_status (
	BYTE drv		/* Physical drive nmuber (0..) */
)
{	
	return RES_OK;
}



/*-----------------------------------------------------------------------*/
/* Read Sector(s)                                                        */

DRESULT disk_read (
	BYTE drv,		/* Physical drive nmuber (0..) */
	BYTE *buff,		/* Data buffer to store read data */
	DWORD sector,		/* Sector address (LBA) */
	BYTE count		/* Number of sectors to read (1..255) */
)
{	
	u32 i;
	
	for(i = 0; i < (u32)count; i++)
	{
		FTL_ReadSector((u8 *)(buff + i * FTL_Info.SectorSize), (u32)sector + i);
	}
	
	return RES_OK;
}



/*-----------------------------------------------------------------------*/
/* Write Sector(s)                                                       */

#if _READONLY == 0
DRESULT disk_write (
	BYTE drv,			/* Physical drive nmuber (0..) */
	const BYTE *buff,		/* Data to be written */
	DWORD sector,			/* Sector address (LBA) */
	BYTE count			/* Number of sectors to write (1..255) */
)
{
    u32 i;
	
	for(i = 0; i < (u32)count; i++)
	{
		FTL_WriteSector((u8 *)(buff + i * FTL_Info.SectorSize), (u32)sector + i);
	}
	    
	return RES_OK;
}
#endif /* _READONLY */



/*-----------------------------------------------------------------------*/
/* Miscellaneous Functions                                               */

DRESULT disk_ioctl (
	BYTE drv,		/* Physical drive nmuber (0..) */
	BYTE ctrl,		/* Control code */
	void *buff		/* Buffer to send/receive control data */
)
{
	switch(ctrl)
	{
	case CTRL_SYNC:
		FTL_FlushBlockBuf();						//дFLASH
		break;
		
	case GET_SECTOR_COUNT:
		*(u32 *)buff =  FTL_Info.SectorPerBlock * FTL_Info.BlockCount;
		break;								//ȡ
		
	case GET_SECTOR_SIZE:
		*(u32 *)buff = FTL_Info.SectorSize ;		//ȡֽ
		break;
		
	case GET_BLOCK_SIZE:
		*(u32 *)buff = FTL_Info.SectorPerBlock;		//ȡÿ
		break;
		
	default :
		*(u32 *)buff = NULL;
		break;
	}
	
	return RES_OK;
}

DWORD get_fattime(void)
{
	return 0;
}























