# 环形LED时钟

观看该项目可点击视频：https://www.bilibili.com/video/BV1b54y187s4/

### 项目介绍

原项目名称为"Round-Led-Clock"，Github地址为：https://github.com/leonvandenbeukel/Round-LED-Clock

本项目为"Round-Led-Clock"的改进版，主要改进和增加了以下功能：
1. 重构主程序及相关注释。
2. 解决原版程序运行一段时间就会死机的问题。
3. NTP服务器改为了国内的服务器(阿里云)，连接更稳定。
4. 增加了SmartConfig功能：首次运行可通过手机设置WIFI名称和密码。
5. 增加了一个电容按键：目前只用来实现重置WIFI名称和密码功能，后续可增加其他功能。
6. 重新设计了控制器外壳模型文件，体积更小且预留TTP223触摸按键模块安装孔。

### 硬件架构

 **硬件列表：** 
1. ESP8266 MINI D1开发板。
2. TTP223电容触摸按键模块。
3. 1米WS2812灯带(1米60灯珠)。
4. 3D打印外壳若干。

 **连接方式：** 

![输入图片说明](https://gitee.com/lv_tong/Round_Led_Clock/raw/master/%E8%AF%B4%E6%98%8E/1.png "在这里输入图片标题")

 **供电方式：** 

使用ESP8266 MINI D1开发板自带Micro-USB口进行供电，要求电源满足5V/2A功率。

### 软件架构

使用Arduino IDE 1.8.13版本进行开发。

注意：原版Arduino IDE并不支持ESP8266板卡，需要自行安装ESP8266板卡支持包，同时需要安装NTPClient库才能正常编译源程序文件。

 **安装板卡：** 

在开发板管理器增加网址：http://arduino.esp8266.com/stable/package_esp8266com_index.json

![输入图片说明](https://gitee.com/lv_tong/Round_Led_Clock/raw/master/%E8%AF%B4%E6%98%8E/2.png "在这里输入图片标题")

之后在开发板管理器中搜索ESP8266，点击安装ESP8266板卡

![输入图片说明](https://gitee.com/lv_tong/Round_Led_Clock/raw/master/%E8%AF%B4%E6%98%8E/3.png "在这里输入图片标题")

最后选择对应ESP8266 MINI D1开发板的型号及参数

![输入图片说明](https://gitee.com/lv_tong/Round_Led_Clock/raw/master/%E8%AF%B4%E6%98%8E/4.png "在这里输入图片标题")

 **安装库：** 

在库管理器中搜索"NTPClient" "FastLED"库，并安装

![输入图片说明](https://gitee.com/lv_tong/Round_Led_Clock/raw/master/%E8%AF%B4%E6%98%8E/5.png "在这里输入图片标题")

![输入图片说明](https://gitee.com/lv_tong/Round_Led_Clock/raw/master/%E8%AF%B4%E6%98%8E/7.png "在这里输入图片标题")

### 使用说明

1. 首次设置WIFI参数：手机在设备附近，打开手机微信并关注"安可信科技"公众号，进入公众号点击右下角"微信配网"可配置设备的WIFI参数。也可以微信扫描下方二维码设置。注意：①手机所在WIFI网络需要与设备将要连接的网络保持一致，否则将导致设备连接失败。②ESP8266芯片只支持2.4G频段网络，如果网络为5.8G频段则不能进行连接。

![输入图片说明](https://gitee.com/lv_tong/Round_Led_Clock/raw/master/%E8%AF%B4%E6%98%8E/6.png "在这里输入图片标题") 

2. 重置WIFI参数：长按电容触摸按键5S，系统重置WIFI参数并复位。
3. 状态汇总：①环形LED全白：设备等待用户设置WIFI参数。②环形LED全红：设备正在尝试连接WIFI。③环形LED全绿：设备连接WIFI成功，即将连接到NTP服务器获取时间。

### 参与贡献

1. 吕桐

