#include <EEPROM.h>

#define SAVE_KEY 0xA2

//存储读取初始化
void saveInit()
{
  EEPROM.begin(512);  
}


//判断是否是第一次运行程序
bool saveIsFristTimeRun(void)
{
  if(EEPROM.read(511) == SAVE_KEY)  
  {
    return false;
  }
  else
  {
    return true;
  }
}

//设置非第一次运行程序标志位
void saveClearFristTimeRunFlag(void)
{
  EEPROM.write(511, SAVE_KEY);
  EEPROM.commit();
}
//设置第一次运行程序标志位
void saveSetFristTimeRunFlag(void)
{
  EEPROM.write(511, 0);
  EEPROM.commit();
}


//存储名称 0-127
void saveSetSsid(char* ssid)
{
  for(int i=0; i<128; i++)
  {
    EEPROM.write(i, ssid[i]);
  }
  EEPROM.commit();
}
//读取名称 0-127
void saveGetSsid(char* ssid)
{
  for(int i=0; i<128; i++)
  {
    ssid[i] = EEPROM.read(i);
  }
}


//存储密码 128-255
void saveSetPass(char* pass)
{
  for(int i=0; i<128; i++)
  {
    EEPROM.write(128+i, pass[i]);
  }
  EEPROM.commit();
}
//读取密码 128-255
void saveGetPass(char* pass)
{
  for(int i=0; i<128; i++)
  {
    pass[i] = EEPROM.read(128+i);
  }
}
