#include <FastLED.h>

static CRGB colorHour = CRGB::Red;
static CRGB colorMinute = CRGB::Green;
static CRGB colorSecond = CRGB::Blue;
static CRGB colorHourMinute = CRGB::Yellow;
static CRGB colorHourSecond = CRGB::Magenta;
static CRGB colorMinuteSecond = CRGB::Cyan;
static CRGB colorAll = CRGB::White;

//LED个数
#define NUM_LEDS 60     
//LED数据引脚
#define DATA_PIN  D3
//LED显示数组
static CRGB LEDs[NUM_LEDS];

#define USE_LED_MOVE_BETWEEN_HOURS true

//小时转成LED所位置
static byte getLEDHour(byte hours, byte minutes)
{
  if (hours > 12)
  {
    hours = hours - 12;
  }

  byte hourLED;
  if (hours <= 5)
  {
    hourLED = (hours * 5) + 30;
  }
  else
  {
    hourLED = (hours * 5) - 30;
  }

  if (USE_LED_MOVE_BETWEEN_HOURS == true)
  {
    if(minutes >= 12 && minutes < 24)
    {
      hourLED += 1;
    }
    else if (minutes >= 24 && minutes < 36) 
    {
      hourLED += 2;
    }
    else if (minutes >= 36 && minutes < 48) 
    {
      hourLED += 3;
    } 
    else if (minutes >= 48) 
    {
      hourLED += 4;
    }
  }
  return hourLED;  
}

//分钟/秒钟转成LED所位置
static byte getLEDMinuteOrSecond(byte minuteOrSecond)
{
  if (minuteOrSecond < 30) 
    return minuteOrSecond + 30;
  else 
    return minuteOrSecond - 30;
}


//LED圆形时钟显示初始化
void ledShowInit()
{
  //LED初始化
  FastLED.addLeds<WS2812B, DATA_PIN, GRB>(LEDs, NUM_LEDS);
  FastLED.delay(10);

  //LED全部点亮为白色 10%亮度
  for (int i=0; i<NUM_LEDS; i++)
  {
      LEDs[i] = CRGB::White;
  }
  FastLED.setBrightness (100); 
  FastLED.show();
}

//LED圆形时钟刷新屏幕
void ledShowRefresh (byte hour_now, byte min_now, byte sec_now)
{
  //时分秒坐标位置转换
  byte hour_pos = getLEDHour(hour_now, min_now);
  byte min_pos = getLEDMinuteOrSecond(min_now);
  byte sec_pos = getLEDMinuteOrSecond(sec_now);
  
  //LED更新显示
  for (int i=0; i<NUM_LEDS; i++)
  {
      LEDs[i] = CRGB::Black;
  }
  LEDs[hour_pos] = colorHour;
  LEDs[min_pos] = colorMinute;
  LEDs[sec_pos] = colorSecond;
  
  if ( hour_pos == min_pos)
  {
    LEDs[hour_pos] = colorHourMinute;
  }
  if ( hour_pos == sec_pos)
  {
    LEDs[hour_pos] = colorHourSecond;    
  }
  if ( min_pos == sec_pos)
  {
      LEDs[min_pos] = colorMinuteSecond;
  }
  if ( min_pos == sec_pos && min_pos == hour_pos)
  {
    LEDs[min_pos] = colorAll;
  }
  
  FastLED.setBrightness (100); 
  FastLED.show();
}

void ledShowAllRed(void)
{
  for (int i=0; i<NUM_LEDS; i++)
  {
      LEDs[i] = CRGB::Red;
  }
  FastLED.setBrightness (100); 
  FastLED.show();
}

void ledShowAllGreen(void)
{
  for (int i=0; i<NUM_LEDS; i++)
  {
      LEDs[i] = CRGB::Green;
  }
  FastLED.setBrightness (100); 
  FastLED.show();
}
