                 ;/***********************************************************/
;/* Title 		: YSM345 code                         */
;/* Build 		: V1.0.0                                   */
;/* TAB WIDTH	: 4                                        */
;/* MODIFY DATE	: 2011.10.18                               */
;/***********************************************************/


; INSTRUCTION CYCLE=FOSC/2
; TIMER0 CLOCK SOURCE = INSTRUCTION CYCLE(FOSC/2)
; TIMER1 CLOCK SOURCE = FOSC/4
; TIME2/3 CLOCK SOURCE = INSTRUCTION CYCLE(FOSC/2)
;
; SUB	A,k	;k-A->A, carry occur,Z=0, no carry occur, Z=1
; SUB	A,R	;R-A->A, carry occur,Z=0, no carry occur, Z=1
; ADD	A,k	;A+k->A, carry occur,Z=1, no carry occur, Z=0
; ADD	A,R	;A-R->A, carry occur,Z=1, no carry occur, Z=0
;-------------------------------------------------------------------------
;--------------------------------------------------------------------------
;Define General register
;
;--------------------------------------------------------------------------
INDR	EQU	0x100	;/* SFR - INDIRECT ADDRESSING REGISTER */
TMR0	EQU	0x101	;/* SFR - 8BITS REAL TIMER CLOCK/COUNTER */
PCL	EQU	0x102   ;/* SFR - THE LOW BYTE OF THE PC COUNTER */
STATUS	EQU	0x103	;/* SFR - STATUS REGISTER */
	C	EQU	0
	DC	EQU	1
	Z	EQU	2
	PD	EQU	3
	TO	EQU	4
	GPR	EQU	5
RAMS	EQU	0x104	;/* SFR - INDIRECT ADDRESSING REGISTER */
PORTA	EQU	0x105	;/* SFR - PORT A DATA */
PORTB	EQU	0x106	;/* SFR - PORT B DATA */
PORTC	EQU	0X107
PAS	EQU	0X115
PBS	EQU	0X116
PCS	EQU	0X117

PBW	EQU	0X120   ;PORTB WAKEUP CONTROL
PAW	EQU	0X121	;PORTA WAKEUP CONTROL
MCR	EQU	0X122	;/* SFR - MAIN CONTROL REGISTER FOR READ AND WRITE , NOTE:REGISTER NAME MODIFIED*/
	PS0	EQU	0
	PS1	EQU	1
	PS2	EQU	2
	PAB	EQU	3
	TM0CE	EQU	4
	T0CS0	EQU	5
	GIE	EQU	6
	T0CS1	EQU	7
ODB	EQU	0X123	;PORTB OPEN-DRAIN SETTING
IORA	EQU	0x125	;/* SFR - PORT A I/O DIRECTION SETTING */
IORB	EQU	0x126	;/* SFR - PORT B I/O DIRECTION SETTING */
IORC	EQU	0X127

IOPA	EQU	0X12A  	;PORTA I/O PULL RESISTOR SETTING
IOPD	EQU	0X12B	;I/O PORT PULL DOWN REGISTER

T1CON	EQU	0x12C	;/* SFR - TIMER 1 CONTROL REGISTER */
	TR1P0	EQU	0
	TR1P1	EQU	1
	TR1S	EQU	2
IOPH	EQU	0x12D	;/* SFR - IO PULLHIGH REGISTER */
	PUA	EQU	0
	PUB	EQU	1
	PUD	EQU	2
	PUE	EQU	3
	PUC	EQU	4
	SSPC	EQU	7
WDTS	EQU	0x12E	;/* SFR - WATCH DOG TIMER SETTINGS REGISTER */
    	WDCKS	EQU	3
	SLP2E	EQU	4
	WDTE	EQU	5
	EIT	EQU	6
	EIS	EQU	7
INTE	EQU	0x12F	;/* SFR - HARDWARE INTERRUPT CONTROL REGISTER */
	TR0IE	EQU	0
	EXIE	EQU	1
	SPIIE	EQU	2
	TR1IE	EQU	3
	ICIE	EQU	4
	WDTIE	EQU	7
PWM1D	EQU	0x130	;/* SFR - PWM1 DUTY CYCLE DATA REGISTER */
PWM2D	EQU	0x131	;/* SFR - PWM2 DUTY CYCLE DATA REGISTER */
PWM1P	EQU	0x132	;/* SFR - PWM1 PERIOD DATA REGISTER */
PWM2P	EQU	0x133	;/* SFR - PWM2 PERIOD DATA REGISTER */
PWMC	EQU	0x134	;/* SFR - PWM CONTROL REGISTER*/
	PWS0	EQU	0
	PWS1	EQU	1
	PWS2	EQU	2
	PW1E	EQU	6
	PW2E	EQU	7
T23CON	EQU	0X135

SPIRB	EQU	0x13A	;/* SFR - SPI DATA READ BUFFER */
SPIWB	EQU	0x13B	;/* SFR - SPI DATA WRITE BUFFER */

SPIS	EQU	0x13C	;/* SFR - SPI STATUS REGISTER */
SPIC	EQU	0x13D	;/* SFR - SPI CONTROL REGISTER */
	SBRS0	EQU	0
	SBRS1	EQU	1
	SBRS2	EQU	2
	SSE	EQU	4
	SRO	EQU	5
	SPIE	EQU	6
	CES	EQU	7
TMR1	EQU	0x13E	;/* SFR - TIMER1 VALUE REGISTER */
TR1CV	EQU	0x13F	;/* SFR - TIMER 1 COMPARATOR VALUE REGISTER */

ADCON1	EQU	0X140
	CHS0	EQU	0
	CHS1	EQU	1
	CHS2	EQU	2
	CHS3	EQU	3
	ADIF	EQU	4
	ADIE	EQU	5
	ADEN	EQU	6
	ADC	EQU	7
ADLSB	EQU	0X141
ADMSB	EQU	0X142
ADCON2	EQU	0X143
	ADCS0	EQU	0
	ADCS1	EQU	1
	ADCS2	EQU	2
	VREFS	EQU	6
	SHE	EQU	7

PAL	EQU	0x14B	;/* SFR - LOW BYTE ADDRESS OF THE DATA LATCH */
PAH	EQU	0x14C	;/* SFR - HIGH BYTE ADDRESS OF THE DATA LATCH */
DACR	EQU	0x14D	;/* SFR - DAC CONTROL REGISTER */
	CVC0	EQU	3
	CVC1	EQU	4
	CVC2	EQU	5
	DAEN	EQU	7
DADAT	EQU	0x14E	;/* SFR - DAC DATA REGISTER */


IOP2	EQU	0X15F

IOSK2	EQU	0X171
	PBHS	EQU	0
	
IOFS	EQU	0X172 	;I/O FUNCTION SETTING REGISTER
    	PMS0	EQU	0
    	PMS1	EQU	1
    	SPIOS	EQU	2
    	CKO0	EQU	3
    	CKO1	EQU	4
    	I2CP0	EQU	6
    	I2CP1	EQU	7
IOSK	EQU	0X174
	PB0S	EQU	0
	PB1S	EQU	1
	PB23S	EQU	2
	PB45S	EQU	3
	PB6S	EQU	4
	PB7S	EQU	5
	PA01S	EQU	6
	PA23S	EQU	7
IOBUF1	EQU	0X175
	PB0T	EQU	0
	PB1T	EQU	1
	PB23T	EQU	2
	PB45T	EQU	3
	PB6T	EQU	4
	PB7T	EQU	5
	PA01T	EQU	6
	PA23T	EQU	7
IOTPS	EQU	0X17A

LVRC	EQU	0X17D

INTF	EQU	0x17F	;/* SFR - INTERRUPT FLAG REGISTER */
	TR0IF	EQU	0
	EXIF	EQU	1
	SPIIF	EQU	2
	TR1IF	EQU	3
	ICIF	EQU	4
	WDTIF	EQU	7     
;-------------------------------------------------------------------------
;Define user register 
;
;-------------------------------------------------------------------------

	   

GPR_A		EQU	0x000	;/* GPR */
ACC_BAC		EQU	0X001
STATUS_BAC	EQU	0X002

DLY_TMP0	EQU	0X003
DLY_TMP1	EQU	0X004
DLY_TMP2	EQU	0X005

TAB_TMPH	EQU	0X008
TAB_TMPL	EQU	0X009
TAB_TMP1	EQU	0X00A
TAB_TMP2	EQU	0X00B

FLAG            EQU     0X00C  
		FAST	EQU	0         		          ;NO S FLAG 
		EP_SF	EQU	1
		PAIR_SF	EQU	2
		P_SF	EQU	3
;--------------------------------------------------------------------------
;RF REGISTER
RF_REG		EQU	0X010
SPI_Data_High	EQU	0X011
SPI_Data_Low	EQU	0X012
TEMP		EQU	0X013
WIDTH		EQU	0X014
SPI_BUF		EQU	0X015
RF_DATA1	EQU	0X019
RF_DATA2	EQU	0X01A
RF_DATA3	EQU	0X01B
RF_DATA4	EQU	0X01C
RF_DATA5	EQU	0X01D
RF_DATA6	EQU	0X01E 
RF_DATA7	EQU	0X01F

TABLE_NUM	EQU	0X020
CH_FREQ		EQU	0X021
FQ_CNT		EQU	0X022
T0M		EQU	0X023
TEMP1		EQU	0X024
DATA_BUF	EQU	0X025
ADDRESS		EQU	0X026
OVER_TIME	EQU	0X027


scan_key_old1		EQU	0X030
scan_key_old2		EQU	0X031
scan_key_old3		EQU	0X032
scan_key_new1		EQU	0X033
scan_key_new2		EQU	0X034
scan_key_new3		EQU	0X035
scan_key_debounce1		EQU	0X036
scan_key_debounce2		EQU	0X037
scan_key_debounce3		EQU	0X038
key_scan_num		EQU	0X039
RL_TIME		EQU	0X03A

POSITIVE_LEVL	EQU	0X040
NEGATIVE_LEVL	EQU	0X041
;RL_MID		EQU	0X042
;MID_L		EQU	0X043
;MID_R		EQU	0X044
;RL_SUM		EQU	0X045
;RL_SUMH		EQU	0X046
;FB_MID		EQU	0X047
;FB_SUM		EQU	0X048
;FB_SUMH		EQU	0X049
;RC_KEY		EQU	0X04A            
control_id			equ		0x043       
repeat_send_id      equ		0x044
key_flag			equ		0x045
temp_rb_new       	equ		0x046
temp_rb_old	        equ		0x047
scan_rb_debounce    equ		0x048
xyq_tx_times_ram_0	equ		0x049
xyq_tx_times_ram_1	equ		0x04a
no_trigger_delay_0	equ		0x04b
temp_ra				equ		0x04c
key_temp			equ		0x04d
sleep_flag			equ		0x04e
no_trigger_delay_1	equ		0x04f


;--------------------------------------------------------------------------
;Define I/O function
;
;--------------------------------------------------------------------------
pRESET_N	EQU	PORTB
RESET_N		EQU	6

piSPI_MISO	EQU	PBS
SPI_MISO	EQU	7
;piSPI_MISO,SPI_MISO

pSPI_MOSI	EQU	PORTA
piSPI_MOSI	EQU	PAS
SPI_MOSI	EQU	0
;pSPI_MOSI,SPI_MOSI

pSPI_CLK	EQU	PORTA
SPI_CLK		EQU	2
;pSPI_CLK,SPI_CLK

piPKT_FLAG	EQU	PAS
PKT_FLAG	EQU	3
;piPKT_FLAG,PKT_FLAG

pSPI_SS		EQU	PORTA
SPI_SS		EQU	4
;pSPI_SS,SPI_SS

pLED		EQU	PORTB
piLED		EQU	PBS
LED		EQU	0
;pLED,LED

;pSDA		EQU	PORTA
;piSDA		EQU	PAS
;SDA		EQU	7
;pSDA,SDA

;pI2C_CLK	EQU	PORTC
;I2C_CLK		EQU	1
;pI2C_CLK,I2C_CLK

;pSPEED_KEY	EQU	PORTB
;piSPEED_KEY	EQU	PBS
;SPEED_KEY	EQU	1




	ORG	0X0000
	JMP	INIT
	ORG	0x0FFF
	JMP	INIT
		
	ORG	0x0011
	JMP	TM1_INT
	ORG	0x0015
TM1_INT:
	PUSH
	CLR	INTF		;TM0жϱ־ȫжϱ־			;125US
/*	INC    T0M	
	inc		no_trigger_delay_0
	mov		a,no_trigger_delay_0
	mov		a,no_trigger_delay_0
		btss    STATUS,2 
		jmp		interrupt_mode_exit
		inc		no_trigger_delay_1
		mov		a,no_trigger_delay_1
		xor		a,@9
		btss	STATUS,2
		jmp     interrupt_mode_exit
		mov		a,@1
		mov		sleep_flag,a
		*/
interrupt_mode_exit:		
			POP
                        RETINT	

;========================================================================================
;RF REGISTER INITIAL VALUE TABLE
;2009-11
;WRITE BY HU
;======================================================================================== 
RF_CHANNEL:
        ADD        PCL,A
        RETLW        @30                                ;2433
        RETLW        @50                                ;2409
        RETLW        @69                                ;2469
;        RETLW        @45                                ;2445
;        RETLW        @17                                ;2417
;        RETLW        @57                                ;2457
;        RETLW        @37                                ;2437
;        RETLW        @13                                ;2413
;        RETLW        @53                                ;2453
        
        RETLW        @0FFH                              ;
        RETLW        @0FFH                              ;
        
        				
	ORG	0x040;0400
;---------------------------------------------------------------------------
;Initial system
;
;---------------------------------------------------------------------------
INIT:
;--------------------------------------------------------------------------
clrr_ram:       
        mov      a,@0xff
        mov      RAMS,a
clrr_ram_1:
        clr      INDR
        drszr    RAMS
        jmp      clrr_ram_1  
        clr      INDR   
;-------------------------------------------------------------------------
;initial I/O port		
 	mov       a,@0x00
        mov       RAMS,a                  
        MOV	A,@0B00001000 	;PA7:,PA6:OUT3,PA5:OUT2,PA4:SS,PA3:PKT,PA2:CLK,PA1:OUT1,PA0:MOSI
	MOV	IORA,A
        MOV	A,@0B10110110	;PB7:MISO,PB6:RESET_N,PB5:on,PB4:off,PB3:forb,PB1:back,PB0:LED
	MOV	IORB,A
        MOV	A,@0B00000000 	;PC1:
	MOV	IORC,A    
        mov       a,@0x00 
        mov       PORTA,a
        mov       PORTB,a
        mov       PORTC,a          
        mov       a,@0x7F        ;enable PA7 pull high
        mov       IOPA,a   
        mov       a,@0B11111111        ;enable PC1~0 pull high
        mov       IOP2,a   
        mov       a,@0x00;0B01111111;0x7f        ;enable PB pull high
        mov       IOPH,a
        
        mov       a,@0x0f;9        ;enable rb pull high
        mov       MCR,a         
        mov       a,@0x00;0B01111110;0x77        ;enable PB pull high
        mov       IOPH,a    
        mov       a,@0x0f;9   	;enable timer 16pre
        mov       MCR,a
        
		 
        clr       TMR0  
	clr		  LVRC         
	BSR		PORTA,7
	
	
	
;-----------------------open time1 interrupt ----------------------------------	
	mov       a,@0x08
        MOV	INTE,A		;enable timer1s
        mov			a,@0X96;1E;0xFF    ;//time1 val
        mov		  TR1CV,a	
        mov		  a,@0x00              ;//time1 val
        mov		  TMR1,a
        mov		  a,@0X04;0x07
        mov		  T1CON,a	
        CLR	INTF    
		   
;;---------------------------------------------------------------------------
;;ʱ0 off,ʱ1 on	
	CALL			DELAY_100MS  
	bsr		portb,3
	nop
	nop
	
;	CALL			DELAY_100MS
;	BCR			pLED,LED				;LED	
	CALL	INITIAL_RF
	
	     
		 
		
	ENI
		 
 		 jmp		MAIN

MAIN:      
   			WDTC
                       
        

main_test:           
       bcr			PORTB,0   
       CALL		  RF_Enter_Idle_State
       CALL		  RF_Reset_RX_FIFO
       CALL		  RF_Enter_RX_State
WAIT_PKT:
			WDTC
		;	call	DELAY_1MS
		;	call	DELAY_1MS
			BTSS	piPKT_FLAG,PKT_FLAG
			JMP		WAIT_PKT
			BSR		PORTB,0
		  MOV     A,@48                         ; Reg48  State Regsiter                                                          
      MOV     RF_REG,A                                                                                                       
      CALL    Read_SPI_Reg                                                                                                   
      MOV     A,SPI_Data_Low                                                                                                 
      AND     A,@0X40                                                                                                        
      BTSC    STATUS,Z                                                                                                       
      JMP     RX_DATA_ERR                    ;no receive pkt flag                                                            
      MOV     A,SPI_Data_High                                                                                                
      AND     A,@0X0C0                                                                                                       
      BTSs    STATUS,Z                                                                                                       
      JMP     RX_DATA_ERR                    ; receive right                                                                 
                                                                                                                             
READ_DATA:                                                                                                                   
      CALL  RF_Enter_Idle_State                                                                                              
      BCR   pSPI_SS,SPI_SS                        ;CSN = 0                                                                   
                                                                                                                             
      MOV   A,@0XB2                                   ; Reg50  0X32|0X80                                                     
      CALL  WriteSPI                                                                                                         
      CALL  ReadSPI                                                                                                          
      MOV   WIDTH,A;RX_Data_Length                                                                                           
                                                                                                                             
      XOR   A,@07 ;NORMAL_DATA_LENGTH                                                                                        
      BTSC  STATUS,Z                                                                                                                                                                                         
      JMP   Save_Data_Length                                                                                                                                                                                                                                                                                                                                                                                                   
      JMP   RX_DATA_ERR       ;Receive_Data_Error                                                                                                                                         
Save_Data_Length:                                                                                                            
      MOV   A,@RF_DATA1                                                                                                      
      MOV   RAMS,A                                                                                                           
Read_FIFO_Loop:                                                                                                              
     CALL   ReadSPI                                                                                                          
     MOV    INDR,A                                                                                                           
     INC    RAMS                                                                                                             
     DRSZR  WIDTH                                                                                                            
     JMP    Read_FIFO_Loop                                                                                                                                                                            
Disable_RF_Commun:                                                                                                           
     BSR    pSPI_SS,SPI_SS     
		 BSR		PORTA,7
		                                                                                                         
      mov   A,RF_DATA1                                                                                                       
      XOR   A,RF_DATA2                                                                                                       
      XOR   A,RF_DATA3                                                                                                       
      XOR   A,RF_DATA4                                                                                                       
      XOR   A,RF_DATA5                                                                                                       
      XOR   A,RF_DATA6 
      XOR   A,RF_DATA7                                                                                                                                                                                                 
      BTSS  STATUS,Z                                                                                                         
      JMP   RX_DATA_ERR  	
			
 ;ȷݴ				
			JMP		WAIT_PKT_2
WAIT_PKT_1:
		   bcr			PORTA,7 
RX_DATA_ERR:	   
WAIT_PKT_2:		   
	;		call	DELAY_1MS
	;		call	DELAY_1MS
	;		call	DELAY_1MS
	;		call	DELAY_1MS
	;		call	DELAY_1MS
	;		call	DELAY_1MS
	;		call	DELAY_1MS
	;		call	DELAY_1MS
	;	    jmp		main_test
			JMP	MAIN
scan_key:
		 inc	key_scan_num
		 mov	a,key_scan_num
		 xor	a,@1
		 btsc	status,2
		 jmp	scan_key_table_1
		 mov	a,key_scan_num
		 xor	a,@2
		 btsc	status,2
		 jmp	scan_key_table_2
		 mov	a,key_scan_num
		 xor	a,@2
		 btsc	status,2
		 jmp	scan_key_table_3
		 jmp	scan_key_table_1
scan_key_table_1:
		 mov	a,@1
		 mov	key_scan_num,a		 		 
		 mov	a,pbs
		 and	a,@0x3E
		 mov	scan_key_new1,a
		 xor	a,scan_key_old1
		 and	a,scan_key_old1
		 btsc	status,2
		 jmp	key_scan1_out
		 inc	scan_key_debounce1
		 mov	a,scan_key_debounce1
		 xor	a,@10
		 btss	status,2
		 jmp	key_scan1_out1
;		 clr	scan_rb_debounce
		 mov	a,scan_key_new1
		 xor	a,scan_key_old1
		 and	a,scan_key_old1
		 and	a,@0x3E
		 or		a,@0x40          		;01xxxxxx   PA5=0
		 mov    key_temp,a              ;01000010 SEG4_OFF  01000100  SEG1_OFF 01001000  SEWEN_ADD 
		 bsr	key_flag,0	            ;01010000 SEG2_OFF  01100000  SEG3_OFF
key_scan1_out:
     mov	a,scan_key_new1
		 mov		scan_key_old1,a	
		 clr	scan_key_debounce1
key_scan1_out1:
         mov	a,pas
         and	a,@0b10111111
         or		a,@0b10100000
         mov	PORTA,a
		 return	
scan_key_table_2:		 		 
		 mov	a,pbs
		 and	a,@0x3E
		 mov	scan_key_new2,a
		 xor	a,scan_key_old2
		 and	a,scan_key_old2
		 btsc	status,2
		 jmp	key_scan2_out
		 inc	scan_key_debounce2
		 mov	a,scan_key_debounce2
		 xor	a,@10
		 btss	status,2
		 jmp	key_scan2_out1
;		 clr	scan_rb_debounce
		 mov	a,scan_key_new2
		 xor	a,scan_key_old2
		 and	a,scan_key_old2
		 and	a,@0x3E
		 or		a,@0x80          		;10xxxxxx   PA6=0
		 mov    key_temp,a              ;10000010   SEG4_ON   10000100   SEG1_ON    10001000    LIGHT_DEC
		 bsr	key_flag,0	            ;10010000   SEG2_ON   10100000   SEG3_ON
key_scan2_out:
     mov	a,scan_key_new2
		 mov		scan_key_old2,a	
		 clr	scan_key_debounce2
key_scan2_out1:
         mov	a,pas
         and	a,@0b01111111
         or		a,@0b01100000
         mov	PORTA,a
		 return	
scan_key_table_3:	
		 clr	key_scan_num	 		 
		 mov	a,pbs
		 and	a,@0x3A
		 mov	scan_key_new3,a
		 xor	a,scan_key_old3
		 and	a,scan_key_old3
		 btsc	status,2
		 jmp	key_scan2_out
		 inc	scan_key_debounce3
		 mov	a,scan_key_debounce3
		 xor	a,@10
		 btss	status,2
		 jmp	key_scan3_out1
;		 clr	scan_rb_debounce
		 mov	a,scan_key_new3
		 xor	a,scan_key_old3
		 and	a,scan_key_old3
		 and	a,@0x3A
		 or		a,@0xc0          		;11xxxxxx    PA7=0
		 mov    key_temp,a              ;11000010    LIGHT_ADD   11001000   SEWEN_DEC 
		 bsr	key_flag,0	            ;11010000    ALL_ON      11100000   ALL_OFF
key_scan3_out:
     mov	a,scan_key_new3
		 mov		scan_key_old3,a	
		 clr	scan_key_debounce3
key_scan3_out1:
         mov	a,pas
         and	a,@0b11011111
         or		a,@0b11000000
         mov	PORTA,a
		 return		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;         

;**************************************************
;                         RF        code
;**************************************************
INITIAL_RF:

	BCR	pRESET_N,RESET_N
	CALL	DELAY_5MS
	CALL	DELAY_5MS
	CALL	DELAY_5MS
;test_loop:
;		  WDTC
;		  jmp	test_loop
	BSR	pRESET_N,RESET_N
	CALL	DELAY_5MS
	CALL	DELAY_5MS
                   
FRAME_REG_INIT:
	MOV	A,@FRAME_TABLE_H
	MOV	TAB_TMPH,A
	MOV	A,@FRAME_TABLE_L
	MOV	TAB_TMPL,A
	MOV	TAB_TMP1,A
	BCR	STATUS,C
	RLC	TAB_TMP1
	MOV	A,TAB_TMPH
	MOV	TAB_TMP2,A
	RLCW	TAB_TMPL
	RLC	TAB_TMP2
	MOV	A,@0B00011111
	AND	TAB_TMP2,A
	MOV	A,TAB_TMP1
	MOV	PAL,A
	MOV	A,TAB_TMP2
	MOV	PAH,A
CONFIG_FRAME:	    
	MOVC
	MOV	RF_REG,A
	MOV	A,@2
	ADD	PAL,A
	MOVC
	MOV	SPI_Data_Low,A
	BSR	PAL,0
	MOVC
	MOV	SPI_Data_High,A
	CALL	Write_SPI_Reg
	BCR	PAL,0
	MOV	A,@2
	ADD	PAL,A
	    
	MOV	A,RF_REG
	SUB	A,@43
	BTSS	STATUS,Z
	JMP	CONFIG_FRAME
	    
	CALL	DELAY_5MS
RF_ON:
	CALL	DELAY_10US

RF_REG_INIT:
	MOV	A,@RF_TABLE_H
	MOV	TAB_TMPH,A
	MOV	A,@RF_TABLE_L
	MOV	TAB_TMPL,A
	MOV	TAB_TMP1,A
	BCR	STATUS,C
	RLC	TAB_TMP1
	MOV	A,TAB_TMPH
	MOV	TAB_TMP2,A
	RLCW	TAB_TMPL
	RLC	TAB_TMP2
	MOV	A,@0B00011111
	AND	TAB_TMP2,A
	MOV	A,TAB_TMP1
	MOV	PAL,A
	MOV	A,TAB_TMP2
	MOV	PAH,A
CONFIG_RF:
	MOVC
	MOV	RF_REG,A
	MOV	A,@2
	ADD	PAL,A
	MOVC
	MOV	SPI_Data_Low,A
	BSR	PAL,0
	MOVC
	MOV	SPI_Data_High,A
	CALL	Write_SPI_Reg
	BCR	PAL,0
	MOV	A,@2
	ADD	PAL,A
	    
	MOV	A,RF_REG
	SUB	A,@27
	BTSS	STATUS,Z
	JMP	CONFIG_RF
	CALL	DELAY_5MS
;;;;;	 
	MOV	A,@01;36
	MOV	RF_REG,A
	CALL	Read_SPI_Reg
	MOV	A,@0x56;6f;0X23
	XOR	A,SPI_Data_High
	BTSS	STATUS,Z
	JMP	INITIAL_RF
	MOV	A,@0x81;e0;0X45
	XOR	A,SPI_Data_Low
	BTSS	STATUS,Z
	JMP	INITIAL_RF
	BCR	pLED,LED
;;;;;	    
;	CALL	ADJUST_CHANNEL
;	CALL	RF_Enter_Idle_State
	CALL	DELAY_5MS
	RETURN
;---------------------------------------------------------------------
;
;
;---------------------------------------------------------------------
;**************************************************
;                         RF        code
;**************************************************

;*********************************************************************
; Function: Write SPI communication subroutine Falling edge
; Input:    ACC
; Output:   None
; I/O Software SPI (PA7:SCK  PA6:SDO  PA5:SDI)
;********************************************************************/
WriteSPI:
          	MOV                SPI_BUF,A
          	MOV                A,@08
                MOV                TEMP,A                                ;output 8-bit
WRITE_SPI_BIT:
		BSR                pSPI_CLK,SPI_CLK                                ;SCK = 1  
          	RLC                SPI_BUF                        ;shift next bit into MSB..
            	BTSS		STATUS,C
              	JMP               MOSI_0
           	BSR                pSPI_MOSI,SPI_MOSI                                ;MOSI=1                OUTPUT
            	JMP               RW_CLK
MOSI_0:
                BCR                pSPI_MOSI,SPI_MOSI                                ;MOSI=0                         
RW_CLK:                                                                            
		BCR                pSPI_CLK,SPI_CLK                                ;SCK = 0   
                WDTC
          	DRSZR            TEMP
               	JMP               WRITE_SPI_BIT
          	BSR                pSPI_MOSI,SPI_MOSI                                ;MOSI=1                OUTPUT
		RETURN
;*********************************************************************
; Function: Read SPI communication subroutine Falling edge
; Input:    None
; Output:   SPI Data
; I/O Software SPI (PA7:SCK  PA6:SDO  PA5:SDI)
;********************************************************************/
ReadSPI:
          	CLR		SPI_BUF
          	MOV                A,@08
                MOV                TEMP,A                                 ;output 8-bit
READ_SPI_1:
		BSR                pSPI_CLK,SPI_CLK                                ;SCK = 1   
          	WDTC
         	NOP
         	NOP
          	NOP
          	NOP
         	BCR                pSPI_CLK,SPI_CLK                                ;SCK = 0  
         	BSR                 piSPI_MISO,SPI_MISO
         	NOP
		BTSS                piSPI_MISO,SPI_MISO                        ; MISO bit
          	JMP                CLR_STATUS_C
          	BSR                 STATUS,C
          	JMP                READ_SPI_MISO
CLR_STATUS_C:
          	BCR                 STATUS,C
READ_SPI_MISO:
          	RLC                SPI_BUF                       ;shift next bit into MSB..
          	DRSZR              TEMP
          	JMP                READ_SPI_1
          	MOV                A,SPI_BUF
          	RETURN                    
;*********************************************************************
;  Function: Write SPI Register
;  Input:    SPI_Addr, SPI_Data_High, SPI_Data_Low
;  Output:   None
;********************************************************************/
Write_SPI_Reg:
		BCR                pSPI_SS,SPI_SS                                ;CSN = 0 
         	MOV                A,RF_REG   
         	AND	A,@0B01111111     
          	CALL                WriteSPI
          	NOP
          	MOV              A,SPI_Data_High
          	CALL                WriteSPI
          	NOP
          	MOV               A,SPI_Data_Low
          	CALL                WriteSPI
          	NOP
		BSR                pSPI_SS,SPI_SS                                ;CSN = 1 
                RETURN
;*********************************************************************
;  Function: Read SPI Register
;  Input:   SPI_Addr
;  Output:  SPI_Data_High,SPI_Data_Low
;********************************************************************/
Read_SPI_Reg:
		BCR                pSPI_SS,SPI_SS                                ;CSN = 0 
          	MOV                A,RF_REG 
          	OR               A,@0X80
          	CALL                WriteSPI
          	CALL	DELAY_10US
          	CALL                ReadSPI
          	MOV              SPI_Data_High,A
          	NOP
          	CALL                ReadSPI
          	MOV               SPI_Data_Low,A
          	NOP
		BSR                pSPI_SS,SPI_SS                                ;CSN = 1 
                RETURN
;*********************************************************************
;  Function: Write FIFO RAM
;  Input:    SPI_Addr,TX_BUF
;  Output:   None
;  Software SPI
;********************************************************************/
RF_Write_FIFO_RAM:
		MOV                WIDTH,A
		BCR                pSPI_SS,SPI_SS                        ;CSN = 0 
          	MOV               A,@0X032                                  ;Reg50
          	CALL                WriteSPI
          	MOV				  A,WIDTH
            CALL                WriteSPI
;		INC			WIDTH
          	MOV               A,@RF_DATA1                                  ; Write DATA START Address
          	MOV               RAMS,A
Write_FIFO_Loop:
          	MOV               A,INDR
          	CALL                WriteSPI
          	INC                RAMS   
          	DRSZR                WIDTH
          	JMP                Write_FIFO_Loop
		BSR                pSPI_SS,SPI_SS                        ;CSN = 1 
                RETURN    
;*********************************************************************
;  Function: Read FIFO RAM
;  Input:    None
;  Output:   RX_BUF    , Receive_Error
;  Software SPI
;********************************************************************/
;RF_Read_FIFO_RAM:
;		BCR                pSPI_SS,SPI_SS                        ;CSN = 0 
;          	MOV               A,@0X0B2                                   ; Reg50  0X32|0X80
;          	CALL                WriteSPI
;          	NOP
;          	CALL                ReadSPI
;        ;  	MOV               WIDTH,A;RX_Data_Length
;         ; 	XOR               A,@0x03;NORMAL_DATA_LENGTH
;          ;	BTSS	STATUS,Z
;         ; 	JMP                Receive_Data_Error
;
;Save_Data_Length:
;          	MOV               A,@RF_DATA1
;          	MOV	            RAMS,A
;Read_FIFO_Loop:
;          	CALL                ReadSPI
;          	MOV               INDR,A
;          	INC                RAMS 
;          	DRSZR                WIDTH
;          	JMP                Read_FIFO_Loop
;Disable_RF_Commun:
;		BSR                pSPI_SS,SPI_SS                        ;CSN = 1 
;                RETURN    
;          
;Receive_Data_Error:
;          	JMP                Disable_RF_Commun
;*********************************************************************
;  Function: Reset TX/RX FIFO
;  Input:    SPI_Addr,SPI_Data_High,SPI_Data_Low
;  Output:   None
;********************************************************************/
RF_Reset_TX_FIFO:
RF_Reset_RX_FIFO:
	MOV	A,@52
	MOV	RF_REG,A
	MOV	A,@0X80
	MOV	SPI_Data_High,A
	MOV	A,@0X80
	MOV	SPI_Data_Low,A
	CALL	Write_SPI_Reg
	RETURN
;*********************************************************************
;  Function: Enter TX State
;  Input:    SPI_Addr,SPI_Data_High,SPI_Data_Low
;  Output:   None
;********************************************************************/
RF_Enter_TX_State:
	MOV	A,@7
	MOV	RF_REG,A
	MOV	A,@0X01
	MOV	SPI_Data_High,A
	MOV	A,@0x30
	MOV	SPI_Data_Low,A
	CALL	Write_SPI_Reg
	RETURN
;*********************************************************************
;  Function: Enter RX State
;  Input:    SPI_Addr,SPI_Data_High,SPI_Data_Low
;  Output:   None
;********************************************************************/
RF_Enter_RX_State:
	MOV	A,@7
	MOV	RF_REG,A
	CLR	SPI_Data_High
	MOV	A,CH_FREQ
	OR	A,@0X80
	MOV	SPI_Data_Low,A
	CALL	Write_SPI_Reg
	RETURN
			

;*********************************************************************
;  Function: RF Enter Idle State
;  Input:    SPI_Addr,SPI_Data_High,SPI_Data_Low
;  Output:   None
;********************************************************************/
RF_Enter_Idle_State:
	MOV	A,@7
	MOV	RF_REG,A
	CLR	SPI_Data_High
	MOV	A,CH_FREQ
	MOV	SPI_Data_Low,A
	CALL	Write_SPI_Reg
	RETURN
;*********************************************************************
;  Function: Set Default Communicate SyncWord
;  Input:    Default_Addr_High, Default_Addr_Low
;  Output:   None
;********************************************************************/
RF_Set_Default_SyncWord:
          	MOV                  A,@0X23
          	MOV               SPI_Data_High,A
          	MOV                   A,@0X45
          	MOV               SPI_Data_Low,A
	        MOV		A,@36               	;Sync_Word_1stAddr	// Reg36
          	MOV           RF_REG,A
          	CALL                Write_SPI_Reg
          	MOV                   A,@00
          	MOV               SPI_Data_High,A
          	MOV                   A,@01
          	MOV               SPI_Data_Low,A
	        MOV		A,@39;7               	;Sync_Word_2ndAddr	// Reg37
          	MOV           RF_REG,A
          	CALL                Write_SPI_Reg
          	RETURN
;*********************************************************************
;  Function: Rewrite Communicate SyncWord
;  Input:    Commun_SyncWord1, Commun_SyncWord2,
;             Commun_SyncWord3, Commun_SyncWord4
;  Output:   None
;********************************************************************/
RF_Set_Commun_SyncWord:
          	MOV		A,RF_DATA3  ;@0x19;
          	MOV           SPI_Data_High,A
          	MOV		A,RF_DATA2 ;@0x79;
          	MOV           SPI_Data_Low,A
          	MOV		A,@36               	;Sync_Word_1stAddr	// Reg36
          	MOV           RF_REG,A
          	CALL                Write_SPI_Reg
          	MOV		A,RF_DATA5  ; @0x05;
          	MOV               SPI_Data_High,A
          	MOV		A,RF_DATA4  ;@0x21;
          	MOV               SPI_Data_Low,A
          	MOV		A,@39;7               	;Sync_Word_2ndAddr	// Reg37
          	MOV           RF_REG,A
          	CALL                Write_SPI_Reg
          	RETURN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ADJUST_CHANNEL:
        	MOV                   A,@0X30                ;2469MHz
        	MOV                   CH_FREQ,A
        	CLR                  TABLE_NUM
        	RETURN	      
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
LOAD_TX_DATA:
;	MOV	A,@07
;	MOV	RF_DATA1,A
	MOV	A,@0x19;FB_TIME
	MOV	RF_DATA1,A
	MOV	A,@0x79;RL_TIME
	MOV	RF_DATA2,A
	mov	a,repeat_send_id
	mov	RF_DATA3,A
	mov	a,control_id
	mov	RF_DATA4,A
	MOV	A,key_temp;FB_TIME
	MOV	RF_DATA5,A
	MOV	A,key_temp;RL_TIME
	MOV	RF_DATA6,A
/*	
	BCR	STATUS,C
	RLCW	RL_KEY
	MOV	RF_DATA5,A
	
	BTSC	FLAG,FAST		; 
	JMP	FAST_MODE
	MOV	A,FB_KEY
	MOV	RF_DATA4,A
	JMP	CHECK_SUM
FAST_MODE:
	BCR	STATUS,C
	RLCW	FB_KEY
	MOV	RF_DATA4,A
*/	
CHECK_SUM:	
	MOV		A,RF_DATA1
	XOR		A,RF_DATA2
	XOR		A,RF_DATA3
	XOR		A,RF_DATA4
	XOR		A,RF_DATA5
	XOR		A,RF_DATA6
;	XOR		A,RF_DATA7
	MOV		RF_DATA7,A		;CheckSum
	RETURN 
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

/* 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;  24C01 SUB  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
BSTART:         
                        BSR         pSDA,SDA                     ; SET SDA
                        CALL         delay_10us                      
                        BCR         pI2C_CLK,I2C_CLK            ; CLR SCL
                        CALL         delay_10us
                        BSR         pI2C_CLK,I2C_CLK             ; SET SCL
                        CALL         delay_10us    
                        BCR         pSDA,SDA                  ; CLR SDA
                        CALL         delay_10us 
                        BCR         pI2C_CLK,I2C_CLK                ; CLR SCL
;                       CALL delay_10us   
                        RETURN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
BSTOP:       
                        BCR        	pSDA,SDA                      ; CLR SDA
                        CALL 	    	delay_10us                           
                        BSR 		pI2C_CLK,I2C_CLK             ; SET SCL
                        CALL 		delay_10us
                        BSR 		pSDA,SDA                      ; SET SDA
;                        CALL delay_10us   
                        RETURN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
BITOUT: 
        		BTSS 		STATUS,C
        		JMP 		BITOUT1
        		BSR 		pSDA,SDA       ;A,1
        		JMP 		BITOUT2
BITOUT1:
        		BCR 		pSDA,SDA      ;A,1
BITOUT2:
        		CALL 		delay_10us
        		BSR 		pI2C_CLK,I2C_CLK      ;0   
        		CALL 		delay_10us
        		BCR 		pI2C_CLK,I2C_CLK      ;0     
;        		CALL 		delay_10us
         		RETURN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
BITIN:
        		BSR 		pSDA,SDA     ;
        		BSR		IORA,7		;SET SDA IN                                     
        		CALL         	delay_10us     
        		BSR         	pI2C_CLK,I2C_CLK                      ;
        		CALL         	delay_10us
        		BTSS         	piSDA,SDA    	;
        		JMP         	BITIN1
        		BSR	 	STATUS,C
        		JMP 		BITIN2
BITIN1:
        		BCR         	STATUS,C
BITIN2:
        		CALL 		delay_10us
        		BCR 		pI2C_CLK,I2C_CLK       ;
                	CALL 		delay_10us
                	BCR		IORA,7		;SET SDA OUT 
;        		CALL 		delay_10us
                	RETURN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
TX:    
       			MOV 		DATA_BUF,A
       			MOV 		A,@08
       			MOV 		TEMP,A
TX0:
       			WDTC	
       			RLC 		DATA_BUF
       			CALL        	BITOUT       
       			DRSZR 		TEMP
       			JMP 		TX0 
        		CALL         	BITIN
       			BTSC 		STATUS,C
       			JMP  		ERROTX
TX1:      
       			BSR 		STATUS,C
        		BCR           	FLAG,EP_SF
       			RETURN
ERROTX:          
        		BSR            	FLAG,EP_SF                        ;read eeprom error flag
       			BCR 		STATUS,C      
       			RETURN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
RX:
       			MOV 		A,@08
       			MOV 		TEMP,A
RX1:
        		WDTC
       			CALL        	BITIN    
       			RLC 		DATA_BUF
       			DRSZR 		TEMP
       			JMP 		RX1          
        		MOV 		A,DATA_BUF
      			RETURN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   WRITE control code ----0A0H
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
RBYTEA:     										;address1/address2/address3/address4/80H
        		mov       	A,@05;08h
        		mov     	WIDTH,A
       			CALL 		BSTART
       			MOV	        A,@0XA0
       			CALL        	TX
       			BTSS      	STATUS,C
       			RETURN
       			MOV        	A,ADDRESS    
       			CALL           	TX
       			CALL        	BSTART
       			MOV      	A,@0XA1
       			CALL          	TX  
       			MOV             A,@RF_DATA1
       			MOV        	RAMS,A
RBYTEA1:
       			CALL         	RX                  
        		MOV        	INDR,A
        		INC         	RAMS
        		DRSZR      	WIDTH
        		JMP         	RBYTEA2
        		JMP         	RBYTEA3
RBYTEA2:
        		BCR 		STATUS,C
        		CALL 		BITOUT
        		JMP           	RBYTEA1
RBYTEA3:
       			BSR 		STATUS,C
       			CALL 		BITOUT
       			CALL 		BSTOP
       			BSR		STATUS,C
       			MOV         	A,@0X80
       			XOR         	A,RF_DATA5
       			BTSS         	STATUS,Z                ;=0X00?
       			BSR           	FLAG,EP_SF                        ;read eeprom error flag
       			CLR         	RF_DATA5
       			RETURN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;   
WBYTEA_LP: 
     			MOV       	A,@05;08h
        		MOV     	WIDTH,A
      			CALL 		BSTART
   			MOV		A,@0A0H 
   			CALL 		TX
   			BTSS 		STATUS,C
           		RETURN
       			MOV 		A,ADDRESS
       			CALL 		TX
         		MOV         	A,@RF_DATA1
                	MOV         	RAMS,A
WBYTEA_LP1:
                	MOV           	A,INDR
                	CALL           	TX
                	INC        	RAMS
                    	DRSZR      	WIDTH
                    	JMP      	WBYTEA_LP1
END_WT:        
        		CALL 		BSTOP      
        		CALL 		DELAY_5MS 
        		BSR 		STATUS,C
        		RETURN
        		
*/        		
;**********************************************************
; temperature measure subprogram 
; 			
; input	 parameter :	
; output parameter :	ACCA,ACCAL
;**********************************************************
/*
MEASURE_RL:		
			CALL    DSCHRG          		; discharge capacitorŵ 
			WDTC	
	                MOV	A,@0B10101010	;PB7:MISO,PB6:RESET_N,PB5:FB,PB4:RL,PB3:CHECK,PB1:SPEED,PB0:LED
			MOV	IORB,A 		; Уʱ,RC_PIN output,RM_PIN input
	                BSR	PORTB,4
	                CALL    M_TIME          		; measure time
	                BCR	PORTB,4
	                ;;;
	                MOV	A,ACCAL
	                MOV	RL_TIME,A
	                ;;;
GET_RL_MID:
	                MOV	A,RL_MID
	                ADD	A,@0X13;0X0C;6
	                MOV	MID_R,A
	                MOV	A,@0X14;6
	                SUB	A,RL_MID
	                MOV	MID_L,A
	                
	                MOV	A,@2
	                MOV	NEGATIVE_LEVL,A
	                MOV	A,@2
	                MOV	POSITIVE_LEVL,A
	                RETURN
;**********************************************************
; temperature measure subprogram 
; 			
; input	 parameter :	
; output parameter :	ACCA,ACCAL
;**********************************************************
MEASURE_FB:		
      			
			CALL    DSCHRG          		; discharge capacitorŵ 
			WDTC	
	                MOV	A,@0B10011010	;PB7:MISO,PB6:RESET_N,PB5:FB,PB4:RL,PB3:CHECK,PB1:SPEED,PB0:LED
			MOV	IORB,A 		; Уʱ,RC_PIN output,RM_PIN input
	                BSR	PORTB,5
	                CALL    M_TIME          		; measure time
	                BCR	PORTB,5
	                  ;;;
	                MOV	A,ACCAL
	                MOV	FB_TIME,A
	                ;;;
GET_FB_MID:	                
	                MOV	A,FB_MID
	                ADD	A,@0X09;6
	                MOV	MID_R,A
	                MOV	A,@0X0E;6
	                SUB	A,FB_MID
	                MOV	MID_L,A
	                
	                MOV	A,@1
	                MOV	NEGATIVE_LEVL,A
	                MOV	A,@2
	                MOV	POSITIVE_LEVL,A
	                RETURN	             
;-----------------------------------------		
DSCHRG:          	; ݷŵӳ 
        		MOV	A,@0B10110010	;PB7:MISO,PB6:RESET_N,PB5:FB,PB4:RL,PB3:CHECK,PB1:SPEED,PB0:LED
			MOV	IORB,A 		; set RC_PIN and RM_PIN input
	                NOP
			BCR	PORTB,3
			CLR	TEMP1
DS_LOOP:            
			WDTC
			NOP
			DRSZR	TEMP1       			; ȴŵȫ 
	                JMP   	DS_LOOP
	                CLR    ACCAL
	                CLR   	ACCA
	                RETURN
;---------------------------------------
M_TIME:          						; ʱӳ           
			IRSZR 	ACCAL
	                JMP   	ENDCHK
	                WDTC
	                IRSZR 	ACCA
	                JMP   	ENDCHK
	                JMP   	END_M
ENDCHK:          
			BTSS  	PBS,3 			; CHECK FOR RTCC TRIP
	                JMP 	M_TIME
END_M:           
			RETURN		
;----------------------------------------------------------------------------		 		        		
;LEVEL_CAL
;
;----------------------------------------------------------------------------			
QH_CAL:
			MOV			A,MID_L;@0X3B			;10%
                       	SUB			A,ACCAL		;average_L-99H=W
                       	BTSC			STATUS,C
                        JMP			RL_M 			;>=0799h
RL_BACK:  								;<0799h		;ֵ                      	
                       	MOV			A,@01
                       	MOV			RC_KEY,A
                       	MOV			A,MID_L;@0X3B
                       	MOV			TEMP1,A
LOOP_RL_BACK:
			WDTC
                       	MOV			A,NEGATIVE_LEVL;@0X03;			;1/32 
                       	SUB			TEMP1,A
                       	BTSS			STATUS,C
                       	JMP			RL_BACK_END			;TEMP1<03
                       	MOV			A,ACCAL
                       	SUB			A,TEMP1
                       	BTSS			STATUS,C
                       	JMP			RL_BACK_END			;TEMP1<ACCAL
                       	INC			RC_KEY				;TEMP1>=ACCAL
                       	JMP			LOOP_RL_BACK
RL_BACK_END:
			MOV			A,RC_KEY
			SUB			A,@0X00
			MOV			RC_KEY,A
			RETURN
RL_M:
			MOV			A,MID_R;@0X47			;10%	
                       	SUB			A,ACCAL
                       	BTSC			STATUS,C	
                       	JMP			RL_UP 			;>=0866h	
RL_STOP:  								;>0799h;<0866h			5k+-5%мֹͣ״̬
			CLR			RC_KEY
			RETURN
RL_UP:			
			MOV			A,MID_R;@0X47			;10%
                       	SUB			ACCAL,A                     	
                       	MOV			A,@01
                       	MOV			RC_KEY,A
LOOP_RL:
			WDTC
                       	MOV			A,POSITIVE_LEVL;@0X02;03;			;1/32 
                       	SUB			ACCAL,A
                       	BTSS			STATUS,C
                       	RETURN
                       	INC			RC_KEY
                       	JMP			LOOP_RL	
*/		
;----------------------------------------------------------------------------		 		        		
;Delay 
;
;----------------------------------------------------------------------------
DELAY_5MS:
                MOV        A,@06                ;10*1.6ms=16ms
                MOV        DLY_TMP0,A
                JMP        DELAY_XMS_LOOP
DELAY_100MS:					;100*1.6ms=160ms
                MOV        A,@100
                MOV        DLY_TMP0,A
DELAY_XMS_LOOP:
                CALL        Delay_1ms
                DRSZR        DLY_TMP0
                JMP        DELAY_XMS_LOOP
                RETURN          
;-------------------------------------------------------------------                
DELAY_1MS:                                      ;100*16us=1.6ms
                MOV        A,@101
                MOV        DLY_TMP1,A
Delay_1ms_loop:         
                CALL        delay_10us
                DRSZR        DLY_TMP1
                JMP        Delay_1ms_loop
                RETURN
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
DELAY_100US:                                     ;16uS  02
                MOV        A,@30
                MOV        DLY_TMP2,A
                JMP		   delay_10us_loop	
DELAY_10US:                                     ;16uS  02
                MOV        A,@03
                MOV        DLY_TMP2,A
delay_10us_loop:
                WDTC
                DRSZR       DLY_TMP2
                JMP         delay_10us_loop
                RETURN  
                
;----------------LOAD_TX_ROLLING_CODE------------------------------------------------------------		 		        		
LOAD_TX_ROLLING_CODE:
	MOV	A,@05
	MOV	RF_DATA1,A
	
	MOV	A,@0FH
	MOV	TAB_TMPH,A
	MOV	A,@0FEH
	MOV	TAB_TMPL,A
	MOV	TAB_TMP1,A
	BCR	STATUS,C
	RLC	TAB_TMP1
	MOV	A,TAB_TMPH
	MOV	TAB_TMP2,A
	RLCW	TAB_TMPL
	RLC	TAB_TMP2
	MOV	A,@0B00011111
	AND	TAB_TMP2,A
	MOV	A,TAB_TMP1
	MOV	PAL,A
	MOV	A,TAB_TMP2
	MOV	PAH,A
	MOVC
	MOV	RF_DATA2,A
	BSR	PAL,0
	MOVC
	MOV	RF_DATA3,A
	
	MOV	A,@0FH
	MOV	TAB_TMPH,A
	MOV	A,@0FDH
	MOV	TAB_TMPL,A
	MOV	TAB_TMP1,A
	BCR	STATUS,C
	RLC	TAB_TMP1
	MOV	A,TAB_TMPH
	MOV	TAB_TMP2,A
	RLCW	TAB_TMPL
	RLC	TAB_TMP2
	MOV	A,@0B00011111
	AND	TAB_TMP2,A
	MOV	A,TAB_TMP1
	MOV	PAL,A
	MOV	A,TAB_TMP2
	MOV	PAH,A
	MOVC
	MOV	RF_DATA4,A
	BSR	PAL,0
	MOVC
	MOV	RF_DATA5,A
	
	MOV	A,@80H
	MOV	RF_DATA6,A
	
	RETURN 
;
;----------------------------------------------------------------------------
ORG	0X0F44
	FRAME_TABLE_H	EQU	0X0F
	FRAME_TABLE_L	EQU	0X44
FRAME_TABLE:
 ;;
 DW @0x0020     	;Register32		**5000
 DW @0X4800  
 DW @0x0021 		;Register33		*
 DW @0x3FC7      
 DW @0x0022		;Register34		*
 DW @0x2000				
 DW @0x0023		;Register35		*
 DW @0x0300
 DW @0x0024        	;Register36
 DW @0x0380					;
 DW @0x0025		;Register37
 DW @0x0380					;
 DW @0x0026		;Register38
 DW @0x5a5a
 DW @0x0027		;Register39
 DW @0x0380
 DW @0x0028		;Register40		*
 DW @0x4402       				;4405
 DW @0x0029		;Register41		*
 DW @0xB800
 DW @0x002A		;Register42		*
 DW @0xFDB0
 DW @0x002B		;Register43
 DW @0x000f  
 ;50			0X000
 ;;
;;-----------------------------
;;-----------------------------
;RF Transceiver Register initial value(Reg0~28)
;writed by:Dai Yicheng
;date:2011,2,22
;registers:
;;-----------------------------
    ORG	0X0F5C
    RF_TABLE_H	EQU	0X0F
	RF_TABLE_L	EQU	0X5C
RF_TABLE:
 ;;
 DW @0X0000         	;Register0
 DW @0x6fe0;6fE0 					;6fef
 DW @0X0001     	;Register1
 DW @0x5681  
 DW @0X0002 		;Register2
 DW @0x6617           	                     
 DW @0X0004 		;Register4
 DW @0x9cc9		
 DW @0X0005 		;Register5
 DW @0x6637		;7 0X0000
 DW @0X0008 		;Register8
 DW @0x6c90
 DW @0X0009 		;Register9		*
 DW @0x4800
 DW @0X000A 		;Register10
 DW @0x7ffd
 DW @0X000B		;Register11
 DW @0x0008
 DW @0X000C		;Register12
 DW @0x0000
 DW @0X000D 		;Register13
 DW @0x48bd
 DW @0x0016 		;Register22
 DW @0x00ff 
 DW @0x0017 		;Register23		*
 DW @0x8005
 DW @0x0018 		;Register24
 DW @0x0067;
 DW @0x0019		;Register25
 DW @0x1659
 DW @0x001a		;Register26
 DW @0x19e0
 DW @0x001b 		;Register27		*
 DW @0x1300
  ;28 0X1800
	END