/**
 * 发送：分包
 * @param {string} data 数据
 */
function unpack(message) {
  if (message.length <= pkgLength) {
    // 单包发送
    return `[wm]${message}`;
  }

  // 分包发送
  let packs = parseInt(message.length / pkgLength);
  const remainder = message.length - packs * pkgLength;
  if (remainder > 0) {
    packs++;
  }

  incrId++;
  const date = new Date();
  const str = `${date.getHours()}${date.getMinutes()}${date.getSeconds()}${date.getMilliseconds()}`;
  const msgKey = `${str}-${incrId}`;
  const parts = [];
  for (let i = 0; i < packs; i++) {
    let part;
    if (i < packs - 1) {
      part = message.substr(i * pkgLength, pkgLength);
    } else {
      part = message.substr(i * pkgLength);
    }
    part = `[wm:${msgKey}:${packs}:${i}]` + part;
    parts.push(part);
  }
  return parts;
}