
/*########################################################################################
**     Copyright (C)        : HaiMa
**     Filename             : Ebooster.c
**     Processor            : dsPIC33EV32GM104
**     Version              : 1.00
**     Compiler             : Microchip DSP C Compiler
**     Date/Time            : 2018-08-09
**     Abstract             : 
**     Main module.         :                     
**     Settings             : 
**     Author               : GFJ 
########################################################################################*/

#include <p33EV32GM104.h>
#include <ECAN1Config.h>

_FOSCSEL(FNOSC_FRC); 				                // Select Internal FRC at POR
_FOSC(FCKSM_CSECMD & OSCIOFNC_OFF & POSCMD_XT);	    // Clock Switching Enabled and Fail Safe Clock Monitor is disabled?OSC2 Pin Function: OSC2 is Clock Output
													// Primary Oscillator Mode: XT Crystal
_FWDT(FWDTEN_OFF); 			            			// Watchdog Timer Enabled/disabled by user software
// _FGS(GCP_OFF);            	                 	// Disable Code Protection 
 _FICD (ICS_PGD1);   
 _FPOR(BOREN0_OFF);      
 _FDMT(DMTEN_DISABLE);
 _FDEVOPT(PWMLOCK_OFF & ALTI2C1_ON);

// ECAN1MSGBUF ecan1msgBuf __attribute__((space(dma),aligned(ECAN1_MSG_BUF_LENGTH*16)));
 
void Configure_IO(void);                       // ????? 

int main(void)
{
    RCONbits.SWDTEN=0;           
    /* Disable Watch Dog Timer*/
	// Configure Oscillator to operate the device at 40Mhz
    // Fosc= Fin*M/(N1*N2), Fcy=Fosc/2
    // Fosc= 8M*40/(2*2)=80Mhz for 8M input clock
	PLLFBD=38;					// M=38
	CLKDIVbits.PLLPOST=0;		// N1=2
	CLKDIVbits.PLLPRE=0;		// N2=2
	    
    // Clock switching to incorporate PLL
    __builtin_write_OSCCONH(0x03);	              	// Initiate Clock Switch to Primary
									               	// Oscillator with PLL (NOSC=0b011)
	__builtin_write_OSCCONL(0x01);	             	// Start clock switching

	while (OSCCONbits.COSC != 0b011) {};          	// Wait for Clock switch to occur	
    while(OSCCONbits.LOCK!=1)  {};                  // Wait for PLL to lock
    
    INTCON1bits.NSTDIS = 0;                         // ?????? 
      
    Configure_IO();
   
    while(1)    
    {        
    }
} 
/*******************************************************************/       
void Configure_IO(void)
{ 
    ANSELBbits.ANSB9 = 0;
    TRISBbits.TRISB9 = 0; 
    
    TRISAbits.TRISA0 = 1;           // ??1????
    TRISAbits.TRISA1 = 1;           // ??2????
    TRISBbits.TRISB0 = 1;           // Signal1
    TRISBbits.TRISB1 = 1;           // Signal2
    
    TRISBbits.TRISB14 = 0;          // PMW1H1
    TRISBbits.TRISB15 = 0;          // PWM1L1
    TRISBbits.TRISB12 = 0;          // PMW1H2
    TRISBbits.TRISB13 = 0;          // PWM1L2
    TRISBbits.TRISB10 = 0;          // PMW1H3
    TRISBbits.TRISB11 = 0;          // PWM1L3
    
    TRISBbits.TRISB6 = 0;      // SCLK
    ANSELCbits.ANSC3 = 0;
    TRISCbits.TRISC3 = 1;      // SDI 
    TRISBbits.TRISB5 = 0;      // SDO 
    ANSELAbits.ANSA4 = 0;
    TRISAbits.TRISA4 = 0;      // SSx

    ANSELBbits.ANSB8 = 0;
    TRISBbits.TRISB8 = 0;      // A0
    ANSELBbits.ANSB7 = 0;
    TRISBbits.TRISB7 = 0;      // A1
     
    TRISAbits.TRISA8 = 0;      // CS
    ANSELCbits.ANSC9 = 0;
    TRISCbits.TRISC9 = 0;      // RESET
    ANSELAbits.ANSA9 = 0;
    TRISAbits.TRISA9 = 0;      // SAMPLE

    RPOR2bits.RP38R = 9;       // SCLK??
    RPOR1bits.RP37R = 8;       // SDO??
    RPINR22bits.SDI2R = 51;    // SDI??
    RPINR22bits.SCK2R = 38;    // SDI??
}
/*******************************************************************/